/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.IndexedSeq;
import clojure.lang.Numbers;
import clojure.lang.Util;
import java.lang.reflect.Array;

public class ArraySeq
extends ASeq
implements IndexedSeq,
IReduce {
    public final Object[] array;
    final int i;

    public static ArraySeq create() {
        return null;
    }

    public static ArraySeq create(Object ... array2) {
        if (array2 == null || array2.length == 0) {
            return null;
        }
        return new ArraySeq(array2, 0);
    }

    static ISeq createFromObject(Object array2) {
        if (array2 == null || Array.getLength(array2) == 0) {
            return null;
        }
        Class<?> aclass = array2.getClass();
        if (aclass == int[].class) {
            return new ArraySeq_int(null, (int[])array2, 0);
        }
        if (aclass == float[].class) {
            return new ArraySeq_float(null, (float[])array2, 0);
        }
        if (aclass == double[].class) {
            return new ArraySeq_double(null, (double[])array2, 0);
        }
        if (aclass == long[].class) {
            return new ArraySeq_long(null, (long[])array2, 0);
        }
        if (aclass == byte[].class) {
            return new ArraySeq_byte(null, (byte[])array2, 0);
        }
        if (aclass == char[].class) {
            return new ArraySeq_char(null, (char[])array2, 0);
        }
        if (aclass == short[].class) {
            return new ArraySeq_short(null, (short[])array2, 0);
        }
        if (aclass == boolean[].class) {
            return new ArraySeq_boolean(null, (boolean[])array2, 0);
        }
        return new ArraySeq(array2, 0);
    }

    ArraySeq(Object array2, int i) {
        this.i = i;
        this.array = (Object[])array2;
    }

    ArraySeq(IPersistentMap meta2, Object array2, int i) {
        super(meta2);
        this.i = i;
        this.array = (Object[])array2;
    }

    @Override
    public Object first() {
        if (this.array != null) {
            return this.array[this.i];
        }
        return null;
    }

    @Override
    public ISeq next() {
        if (this.array != null && this.i + 1 < this.array.length) {
            return new ArraySeq(this.array, this.i + 1);
        }
        return null;
    }

    @Override
    public int count() {
        if (this.array != null) {
            return this.array.length - this.i;
        }
        return 0;
    }

    @Override
    public int index() {
        return this.i;
    }

    @Override
    public ArraySeq withMeta(IPersistentMap meta2) {
        return new ArraySeq(meta2, this.array, this.i);
    }

    @Override
    public Object reduce(IFn f) {
        if (this.array != null) {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }
        return null;
    }

    @Override
    public Object reduce(IFn f, Object start) {
        if (this.array != null) {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }
        return null;
    }

    @Override
    public int indexOf(Object o) {
        if (this.array != null) {
            for (int j = this.i; j < this.array.length; ++j) {
                if (!Util.equals(o, this.array[j])) continue;
                return j - this.i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        block4: {
            if (this.array == null) break block4;
            if (o == null) {
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (this.array[j] != null) continue;
                    return j - this.i;
                }
            } else {
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (!o.equals(this.array[j])) continue;
                    return j - this.i;
                }
            }
        }
        return -1;
    }

    public static class ArraySeq_boolean
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final boolean[] array;
        final int i;

        ArraySeq_boolean(IPersistentMap meta2, boolean[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        @Override
        public Object first() {
            return this.array[this.i];
        }

        @Override
        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_boolean(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        @Override
        public int count() {
            return this.array.length - this.i;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public ArraySeq_boolean withMeta(IPersistentMap meta2) {
            return new ArraySeq_boolean(meta2, this.array, this.i);
        }

        @Override
        public Object reduce(IFn f) {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        @Override
        public Object reduce(IFn f, Object start) {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof Boolean) {
                boolean b = (Boolean)o;
                for (int j = this.i; j < this.array.length; ++j) {
                    if (b != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o instanceof Boolean) {
                boolean b = (Boolean)o;
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (b != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_short
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final short[] array;
        final int i;

        ArraySeq_short(IPersistentMap meta2, short[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        @Override
        public Object first() {
            return this.array[this.i];
        }

        @Override
        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_short(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        @Override
        public int count() {
            return this.array.length - this.i;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public ArraySeq_short withMeta(IPersistentMap meta2) {
            return new ArraySeq_short(meta2, this.array, this.i);
        }

        @Override
        public Object reduce(IFn f) {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        @Override
        public Object reduce(IFn f, Object start) {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof Short) {
                short s = (Short)o;
                for (int j = this.i; j < this.array.length; ++j) {
                    if (s != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o instanceof Short) {
                short s = (Short)o;
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (s != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_char
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final char[] array;
        final int i;

        ArraySeq_char(IPersistentMap meta2, char[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        @Override
        public Object first() {
            return Character.valueOf(this.array[this.i]);
        }

        @Override
        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_char(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        @Override
        public int count() {
            return this.array.length - this.i;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public ArraySeq_char withMeta(IPersistentMap meta2) {
            return new ArraySeq_char(meta2, this.array, this.i);
        }

        @Override
        public Object reduce(IFn f) {
            Object ret = Character.valueOf(this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Character.valueOf(this.array[x]));
            }
            return ret;
        }

        @Override
        public Object reduce(IFn f, Object start) {
            Object ret = f.invoke(start, Character.valueOf(this.array[this.i]));
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Character.valueOf(this.array[x]));
            }
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof Character) {
                char c = ((Character)o).charValue();
                for (int j = this.i; j < this.array.length; ++j) {
                    if (c != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(Character.valueOf(this.array[j]))) continue;
                return j - this.i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o instanceof Character) {
                char c = ((Character)o).charValue();
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (c != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(Character.valueOf(this.array[j]))) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_byte
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final byte[] array;
        final int i;

        ArraySeq_byte(IPersistentMap meta2, byte[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        @Override
        public Object first() {
            return this.array[this.i];
        }

        @Override
        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_byte(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        @Override
        public int count() {
            return this.array.length - this.i;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public ArraySeq_byte withMeta(IPersistentMap meta2) {
            return new ArraySeq_byte(meta2, this.array, this.i);
        }

        @Override
        public Object reduce(IFn f) {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        @Override
        public Object reduce(IFn f, Object start) {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof Byte) {
                byte b = (Byte)o;
                for (int j = this.i; j < this.array.length; ++j) {
                    if (b != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.i; j < this.array.length; ++j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o instanceof Byte) {
                byte b = (Byte)o;
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (b != this.array[j]) continue;
                    return j - this.i;
                }
            }
            if (o == null) {
                return -1;
            }
            for (int j = this.array.length - 1; j >= this.i; --j) {
                if (!o.equals(this.array[j])) continue;
                return j - this.i;
            }
            return -1;
        }
    }

    public static class ArraySeq_long
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final long[] array;
        final int i;

        ArraySeq_long(IPersistentMap meta2, long[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        @Override
        public Object first() {
            return Numbers.num(this.array[this.i]);
        }

        @Override
        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_long(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        @Override
        public int count() {
            return this.array.length - this.i;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public ArraySeq_long withMeta(IPersistentMap meta2) {
            return new ArraySeq_long(meta2, this.array, this.i);
        }

        @Override
        public Object reduce(IFn f) {
            Object ret = Numbers.num(this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Numbers.num(this.array[x]));
            }
            return ret;
        }

        @Override
        public Object reduce(IFn f, Object start) {
            Object ret = f.invoke(start, Numbers.num(this.array[this.i]));
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Numbers.num(this.array[x]));
            }
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof Number) {
                long l = ((Number)o).longValue();
                for (int j = this.i; j < this.array.length; ++j) {
                    if (l != this.array[j]) continue;
                    return j - this.i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o instanceof Number) {
                long l = ((Number)o).longValue();
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (l != this.array[j]) continue;
                    return j - this.i;
                }
            }
            return -1;
        }
    }

    public static class ArraySeq_double
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final double[] array;
        final int i;

        ArraySeq_double(IPersistentMap meta2, double[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        @Override
        public Object first() {
            return this.array[this.i];
        }

        @Override
        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_double(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        @Override
        public int count() {
            return this.array.length - this.i;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public ArraySeq_double withMeta(IPersistentMap meta2) {
            return new ArraySeq_double(meta2, this.array, this.i);
        }

        @Override
        public Object reduce(IFn f) {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        @Override
        public Object reduce(IFn f, Object start) {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof Number) {
                double d = ((Number)o).doubleValue();
                for (int j = this.i; j < this.array.length; ++j) {
                    if (d != this.array[j]) continue;
                    return j - this.i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o instanceof Number) {
                double d = ((Number)o).doubleValue();
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (d != this.array[j]) continue;
                    return j - this.i;
                }
            }
            return -1;
        }
    }

    public static class ArraySeq_float
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final float[] array;
        final int i;

        ArraySeq_float(IPersistentMap meta2, float[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        @Override
        public Object first() {
            return Numbers.num(this.array[this.i]);
        }

        @Override
        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_float(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        @Override
        public int count() {
            return this.array.length - this.i;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public ArraySeq_float withMeta(IPersistentMap meta2) {
            return new ArraySeq_float(meta2, this.array, this.i);
        }

        @Override
        public Object reduce(IFn f) {
            Object ret = Numbers.num(this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Numbers.num(this.array[x]));
            }
            return ret;
        }

        @Override
        public Object reduce(IFn f, Object start) {
            Object ret = f.invoke(start, Numbers.num(this.array[this.i]));
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Numbers.num(this.array[x]));
            }
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof Number) {
                float f = ((Number)o).floatValue();
                for (int j = this.i; j < this.array.length; ++j) {
                    if (f != this.array[j]) continue;
                    return j - this.i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o instanceof Number) {
                float f = ((Number)o).floatValue();
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (f != this.array[j]) continue;
                    return j - this.i;
                }
            }
            return -1;
        }
    }

    public static class ArraySeq_int
    extends ASeq
    implements IndexedSeq,
    IReduce {
        public final int[] array;
        final int i;

        ArraySeq_int(IPersistentMap meta2, int[] array2, int i) {
            super(meta2);
            this.array = array2;
            this.i = i;
        }

        @Override
        public Object first() {
            return this.array[this.i];
        }

        @Override
        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_int(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        @Override
        public int count() {
            return this.array.length - this.i;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public ArraySeq_int withMeta(IPersistentMap meta2) {
            return new ArraySeq_int(meta2, this.array, this.i);
        }

        @Override
        public Object reduce(IFn f) {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        @Override
        public Object reduce(IFn f, Object start) {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof Number) {
                int k = ((Number)o).intValue();
                for (int j = this.i; j < this.array.length; ++j) {
                    if (k != this.array[j]) continue;
                    return j - this.i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o instanceof Number) {
                int k = ((Number)o).intValue();
                for (int j = this.array.length - 1; j >= this.i; --j) {
                    if (k != this.array[j]) continue;
                    return j - this.i;
                }
            }
            return -1;
        }
    }
}

