/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.compare.internal.LCSSettings;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.outerj.daisy.diff.html.TextNodeComparator;
import org.outerj.daisy.diff.output.DiffOutput;
import org.outerj.daisy.diff.output.Differ;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLDiffer
implements Differ {
    private DiffOutput output;

    public HTMLDiffer(DiffOutput diffOutput) {
        this.output = diffOutput;
    }

    @Override
    public void diff(TextNodeComparator textNodeComparator, TextNodeComparator textNodeComparator2) throws SAXException {
        LCSSettings lCSSettings = new LCSSettings();
        lCSSettings.setUseGreedyMethod(false);
        RangeDifference[] rangeDifferenceArray = RangeDifferencer.findDifferences(lCSSettings, textNodeComparator, textNodeComparator2);
        List<RangeDifference> list = this.preProcess(rangeDifferenceArray);
        int n = 0;
        int n2 = 0;
        for (RangeDifference rangeDifference : list) {
            if (rangeDifference.leftStart() > n) {
                textNodeComparator2.handlePossibleChangedPart(n, rangeDifference.leftStart(), n2, rangeDifference.rightStart(), textNodeComparator);
            }
            if (rangeDifference.leftLength() > 0) {
                textNodeComparator2.markAsDeleted(rangeDifference.leftStart(), rangeDifference.leftEnd(), textNodeComparator, rangeDifference.rightStart());
            }
            textNodeComparator2.markAsNew(rangeDifference.rightStart(), rangeDifference.rightEnd());
            n = rangeDifference.leftEnd();
            n2 = rangeDifference.rightEnd();
        }
        if (n < textNodeComparator.getRangeCount()) {
            textNodeComparator2.handlePossibleChangedPart(n, textNodeComparator.getRangeCount(), n2, textNodeComparator2.getRangeCount(), textNodeComparator);
        }
        textNodeComparator2.expandWhiteSpace();
        this.output.generateOutput(textNodeComparator2.getBodyNode());
    }

    private List<RangeDifference> preProcess(RangeDifference[] rangeDifferenceArray) {
        LinkedList<RangeDifference> linkedList = new LinkedList<RangeDifference>();
        for (int i = 0; i < rangeDifferenceArray.length; ++i) {
            int n = rangeDifferenceArray[i].leftStart();
            int n2 = rangeDifferenceArray[i].leftEnd();
            int n3 = rangeDifferenceArray[i].rightStart();
            int n4 = rangeDifferenceArray[i].rightEnd();
            int n5 = rangeDifferenceArray[i].kind();
            int n6 = n2 - n;
            int n7 = n4 - n3;
            while (i + 1 < rangeDifferenceArray.length && rangeDifferenceArray[i + 1].kind() == n5) {
                int[] nArray = new int[]{n6, rangeDifferenceArray[i + 1].leftLength(), n7, rangeDifferenceArray[i + 1].rightLength()};
                if (!(HTMLDiffer.score(nArray) > (double)(rangeDifferenceArray[i + 1].leftStart() - n2))) break;
                n2 = rangeDifferenceArray[i + 1].leftEnd();
                n4 = rangeDifferenceArray[i + 1].rightEnd();
                n6 = n2 - n;
                n7 = n4 - n3;
                ++i;
            }
            linkedList.add(new RangeDifference(n5, n3, n7, n, n6));
        }
        return linkedList;
    }

    public static double score(int ... nArray) {
        if (nArray[0] == 0 && nArray[1] == 0 || nArray[2] == 0 && nArray[3] == 0) {
            return 0.0;
        }
        double d = 0.0;
        int[] nArray2 = nArray;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            double d2;
            for (d2 = (double)nArray2[i]; d2 > 3.0; d2 *= 0.5) {
                d += 3.0;
                d2 -= 3.0;
            }
            d += d2;
        }
        return d / (1.5 * (double)nArray.length);
    }
}

