/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html.dom;

import java.util.ArrayList;
import java.util.List;
import org.outerj.daisy.diff.html.dom.BodyNode;
import org.outerj.daisy.diff.html.dom.DomTree;
import org.outerj.daisy.diff.html.dom.ImageNode;
import org.outerj.daisy.diff.html.dom.Node;
import org.outerj.daisy.diff.html.dom.TagNode;
import org.outerj.daisy.diff.html.dom.TextNode;
import org.outerj.daisy.diff.html.dom.WhiteSpaceNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomTreeBuilder
extends DefaultHandler
implements DomTree {
    private List<TextNode> textNodes = new ArrayList<TextNode>(50);
    private BodyNode bodyNode = new BodyNode();
    private TagNode currentParent = this.bodyNode;
    private StringBuilder newWord = new StringBuilder();
    protected boolean documentStarted = false;
    protected boolean documentEnded = false;
    protected boolean bodyStarted = false;
    protected boolean bodyEnded = false;
    private boolean whiteSpaceBeforeThis = false;
    private Node lastSibling = null;

    @Override
    public BodyNode getBodyNode() {
        return this.bodyNode;
    }

    @Override
    public List<TextNode> getTextNodes() {
        return this.textNodes;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.documentStarted) {
            throw new IllegalStateException("This Handler only accepts one document");
        }
        this.documentStarted = true;
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.documentStarted || this.documentEnded) {
            throw new IllegalStateException();
        }
        this.endWord();
        this.documentEnded = true;
        this.documentStarted = false;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!this.documentStarted || this.documentEnded) {
            throw new IllegalStateException();
        }
        if (this.bodyStarted && !this.bodyEnded) {
            TagNode tagNode;
            this.endWord();
            this.currentParent = tagNode = new TagNode(this.currentParent, string2, attributes);
            this.lastSibling = null;
            if (this.whiteSpaceBeforeThis && tagNode.isInline()) {
                tagNode.setWhiteBefore(true);
            }
            this.whiteSpaceBeforeThis = false;
        } else if (!this.bodyStarted && string2.equalsIgnoreCase("body")) {
            this.bodyStarted = true;
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!this.documentStarted || this.documentEnded) {
            throw new IllegalStateException();
        }
        if (string2.equalsIgnoreCase("body")) {
            this.bodyEnded = true;
        } else if (this.bodyStarted && !this.bodyEnded) {
            if (string2.equalsIgnoreCase("img")) {
                ImageNode imageNode = new ImageNode(this.currentParent, this.currentParent.getAttributes());
                imageNode.setWhiteBefore(this.whiteSpaceBeforeThis);
                this.lastSibling = imageNode;
                this.textNodes.add(imageNode);
            }
            this.endWord();
            this.lastSibling = this.currentParent.isInline() ? this.currentParent : null;
            this.currentParent = this.currentParent.getParent();
            this.whiteSpaceBeforeThis = false;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.documentStarted || this.documentEnded) {
            throw new IllegalStateException();
        }
        for (int i = n; i < n + n2; ++i) {
            char c = cArray[i];
            if (DomTreeBuilder.isDelimiter(c)) {
                this.endWord();
                if (WhiteSpaceNode.isWhiteSpace(c) && !this.currentParent.isPre() && !this.currentParent.inPre()) {
                    if (this.lastSibling != null) {
                        this.lastSibling.setWhiteAfter(true);
                    }
                    this.whiteSpaceBeforeThis = true;
                    continue;
                }
                TextNode textNode = new TextNode(this.currentParent, Character.toString(c));
                textNode.setWhiteBefore(this.whiteSpaceBeforeThis);
                this.whiteSpaceBeforeThis = false;
                this.lastSibling = textNode;
                this.textNodes.add(textNode);
                continue;
            }
            this.newWord.append(c);
        }
    }

    private void endWord() {
        if (this.newWord.length() > 0) {
            TextNode textNode = new TextNode(this.currentParent, this.newWord.toString());
            textNode.setWhiteBefore(this.whiteSpaceBeforeThis);
            this.whiteSpaceBeforeThis = false;
            this.lastSibling = textNode;
            this.textNodes.add(textNode);
            this.newWord.setLength(0);
        }
    }

    public static boolean isDelimiter(char c) {
        if (WhiteSpaceNode.isWhiteSpace(c)) {
            return true;
        }
        switch (c) {
            case '!': 
            case '\"': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '_': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }
}

