/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.extract;

import cc.mallet.extract.LabeledSpan;
import cc.mallet.extract.LabeledSpans;
import cc.mallet.extract.Span;
import cc.mallet.extract.StringSpan;
import cc.mallet.extract.Tokenization;
import cc.mallet.extract.TokenizationFilter;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.Sequence;
import java.io.Serializable;

public class DefaultTokenizationFilter
implements TokenizationFilter,
Serializable {
    public LabeledSpans constructLabeledSpans(LabelAlphabet dict, Object document, Label backgroundTag, Tokenization input, Sequence seq) {
        LabeledSpans labeled = new LabeledSpans(document);
        this.addSpansFromTags(labeled, input, seq, dict, backgroundTag);
        return labeled;
    }

    private void addSpansFromTags(LabeledSpans labeled, Tokenization input, Sequence tags, LabelAlphabet dict, Label backgroundTag) {
        int i = 0;
        int docidx = 0;
        while (i < tags.size()) {
            Label nextTag;
            Label thisTag = dict.lookupLabel(tags.get(i).toString());
            int startTokenIdx = i;
            while (i < tags.size() && thisTag == (nextTag = dict.lookupLabel(tags.get(i).toString()))) {
                ++i;
            }
            int endTokenIdx = i;
            Span span = input.subspan(startTokenIdx, endTokenIdx);
            this.addBackgroundIfNecessary(labeled, (StringSpan)span, docidx, backgroundTag);
            docidx = ((StringSpan)span).getEndIdx();
            labeled.add(new LabeledSpan(span, thisTag, thisTag == backgroundTag));
        }
    }

    private void addBackgroundIfNecessary(LabeledSpans labeled, StringSpan span, int docidx, Label background) {
        int nextIdx = span.getStartIdx();
        if (docidx < nextIdx) {
            StringSpan newSpan = new StringSpan((CharSequence)span.getDocument(), docidx, nextIdx);
            labeled.add(new LabeledSpan(newSpan, background, true));
        }
    }
}

