/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference;

import cc.mallet.grmm.inference.AbstractInferencer;
import cc.mallet.grmm.inference.Inferencer;
import cc.mallet.grmm.inference.JunctionTree;
import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BruteForceInferencer
extends AbstractInferencer
implements Inferencer {
    transient Factor cachedJoint;
    private static final long serialVersionUID = 1L;

    public Factor joint(FactorGraph model) {
        AbstractTableFactor joint = TableFactor.multiplyAll(model.factors());
        joint.normalize();
        return joint;
    }

    public Factor joint(JunctionTree jt) {
        AbstractTableFactor joint = TableFactor.multiplyAll(jt.clusterPotentials());
        for (TableFactor pot : jt.sepsetPotentials()) {
            joint.divideBy(pot);
        }
        joint.normalize();
        return joint;
    }

    public void computeMarginals(FactorGraph mdl) {
        this.cachedJoint = this.joint(mdl);
    }

    public void computeMarginals(JunctionTree jt) {
        this.cachedJoint = this.joint(jt);
    }

    public Factor lookupMarginal(Variable var) {
        return this.cachedJoint.marginalize(var);
    }

    public Factor lookupMarginal(VarSet c) {
        return this.cachedJoint.marginalize(c);
    }

    public double lookupJoint(Assignment assn) {
        return this.cachedJoint.value(assn);
    }

    public double lookupLogJoint(Assignment assn) {
        return Math.log(this.cachedJoint.value(assn));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

