/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

class SeaOfGatesCellBuilder {
    static final boolean USE_MUTABLE_DATABASE = false;
    private final EditingPreferences ep;
    private final Snapshot oldSnapshot;
    private final Tool oldTool;
    private final Environment oldEnvironment;
    private final CellTree oldCellTree;
    private final CellBackup oldCellBackup;
    private final CellTree[] oldCellTrees;
    private final TechPool oldTechPool;
    private final CellRevision oldCellRevision;
    private final ImmutableCell oldCell;
    final CellId cellId;
    final Cell cell;
    final String resultCellName;
    private Cell resultCell;
    private Snapshot curSnapshot;
    private final CellBackup[] curCellBackups;
    private CellTree curCellTree;
    private CellBackup curCellBackup;
    private final BitSet curNodes = new BitSet();
    private int curNodesCount;
    private int lastNodeId;
    private final TreeMap<Name, MaxNodeSuffix> maxNodeSuffixesOrdered = new TreeMap(Name.STRING_NUMBER_ORDER);
    private final IdentityHashMap<PrimitiveNodeId, MaxNodeSuffix> maxNodeSuffixes = new IdentityHashMap();
    private final IdentityHashMap<SeaOfGatesEngine.RouteNode, ImmutableNodeInst> addedNodesToNodeInst = new IdentityHashMap();
    private final List<ImmutableArcInst> curArcs = new ArrayList<ImmutableArcInst>();
    private int maxArcSuffix;
    private final MyShapeBuilder resultShapeBuilder;

    SeaOfGatesCellBuilder(Snapshot snapshot, Cell cell, String resultCellName, EditingPreferences ep) {
        CellId resultCellId;
        this.ep = ep;
        this.cell = cell;
        this.cellId = cell.getId();
        this.resultCellName = resultCellName;
        this.resultCell = null;
        this.oldSnapshot = snapshot;
        this.oldTool = this.oldSnapshot.tool;
        this.oldEnvironment = this.oldSnapshot.environment;
        this.oldCellTree = snapshot.getCellTree(this.cellId);
        this.oldCellBackup = this.oldCellTree.top;
        this.oldCellTrees = this.oldCellTree.getSubTrees();
        this.oldTechPool = this.oldCellTree.techPool;
        this.oldCellRevision = this.oldCellBackup.cellRevision;
        this.oldCell = this.oldCellRevision.d;
        int maxCellIndex = -1;
        if (resultCellName != null) {
            resultCellId = this.cellId.libId.newCellId(CellName.newName(resultCellName, View.LAYOUT, 1));
            maxCellIndex = resultCellId.cellIndex;
            this.resultShapeBuilder = new MyShapeBuilder(resultCellId);
        } else {
            this.resultShapeBuilder = null;
        }
        for (CellTree cellTree : this.oldSnapshot.cellTrees) {
            if (cellTree == null) continue;
            maxCellIndex = Math.max(maxCellIndex, cellTree.top.cellRevision.d.cellId.cellIndex);
        }
        this.curCellBackups = new CellBackup[maxCellIndex + 1];
        for (CellTree cellTree : this.oldSnapshot.cellTrees) {
            if (cellTree == null) continue;
            this.curCellBackups[cellTree.top.cellRevision.d.cellId.cellIndex] = cellTree.top;
        }
        this.lastNodeId = -1;
        for (ImmutableNodeInst n : this.oldCellRevision.nodes) {
            int nodeId = n.nodeId;
            assert (!this.curNodes.get(nodeId));
            this.curNodes.set(nodeId);
            this.lastNodeId = Math.max(this.lastNodeId, nodeId);
        }
        this.curNodesCount = this.oldCellRevision.nodes.size();
        if (this.resultShapeBuilder != null) {
            resultCellId = this.resultShapeBuilder.cellId;
            this.curCellBackups[resultCellId.cellIndex] = this.resultShapeBuilder.commit();
            int nodeId = ++this.lastNodeId;
            Name baseName = resultCellId.cellName.getBasename();
            MaxNodeSuffix maxSuffix = this.maxNodeSuffixesOrdered.get(baseName);
            if (maxSuffix == null) {
                maxSuffix = new MaxNodeSuffix(this, baseName);
                this.maxNodeSuffixesOrdered.put(baseName, maxSuffix);
            }
            Name name = maxSuffix.getNextName();
            TextDescriptor nameTd = ep.getNodeTextDescriptor();
            Orientation orient = Orientation.IDENT;
            EPoint anchor = EPoint.ORIGIN;
            EPoint size2 = EPoint.ORIGIN;
            int flags = 0;
            int techBits = 0;
            TextDescriptor protoTd = ep.getInstanceTextDescriptor();
            ImmutableNodeInst n = ImmutableNodeInst.newInstance(nodeId, resultCellId, name, nameTd, orient, anchor, size2, flags, techBits, protoTd);
            maxSuffix.add(n);
            assert (!this.curNodes.get(nodeId));
            this.curNodes.set(nodeId);
            ++this.curNodesCount;
        }
        this.maxArcSuffix = -1;
        for (ImmutableArcInst a : this.oldCellRevision.arcs) {
            int arcId = a.arcId;
            while (this.curArcs.size() <= arcId) {
                this.curArcs.add(null);
            }
            assert (this.curArcs.get(arcId) == null);
            this.curArcs.set(arcId, a);
            Name name = a.name;
            if (!name.isTempname()) continue;
            assert (name.getBasename() == ImmutableArcInst.BASENAME);
            this.maxArcSuffix = Math.max(this.maxArcSuffix, name.getNumSuffix());
        }
        this.curSnapshot = this.oldSnapshot;
        this.curCellTree = this.oldCellTree;
        this.curCellBackup = this.oldCellBackup;
    }

    synchronized void instantiate(SeaOfGatesEngine.RouteResolution resolution) {
        TextDescriptor nameTd;
        Serializable protoId;
        if (this.resultShapeBuilder == null) {
            Iterator<Serializable> i$ = resolution.nodesIDsToKill.iterator();
            while (i$.hasNext()) {
                int nodeId = (Integer)i$.next();
                assert (this.curNodes.get(nodeId));
                this.curNodes.clear(nodeId);
                --this.curNodesCount;
            }
            i$ = resolution.arcsIDsToKill.iterator();
            while (i$.hasNext()) {
                int arcId = (Integer)i$.next();
                assert (this.curArcs.get(arcId) != null);
                this.curArcs.set(arcId, null);
            }
        }
        for (SeaOfGatesEngine.RouteNode rn : resolution.nodesToRoute) {
            if (rn.exists()) continue;
            int nodeId = ++this.lastNodeId;
            protoId = (PrimitiveNodeId)rn.getProtoId();
            MaxNodeSuffix maxSuffix = this.maxNodeSuffixes.get(protoId);
            if (maxSuffix == null) {
                Name baseName = rn.getBaseName();
                maxSuffix = this.maxNodeSuffixesOrdered.get(baseName);
                if (maxSuffix == null) {
                    maxSuffix = new MaxNodeSuffix(this, baseName);
                    this.maxNodeSuffixesOrdered.put(baseName, maxSuffix);
                }
                this.maxNodeSuffixes.put((PrimitiveNodeId)protoId, maxSuffix);
            }
            Name name = maxSuffix.getNextName();
            nameTd = this.ep.getNodeTextDescriptor();
            Orientation orient = rn.getOrient();
            EPoint anchor = rn.getLoc();
            EPoint size2 = rn.getSize();
            int flags = 0;
            int techBits = rn.getTechBits();
            TextDescriptor protoTd = this.ep.getInstanceTextDescriptor();
            ImmutableNodeInst n = ImmutableNodeInst.newInstance(nodeId, (NodeProtoId)((Object)protoId), name, nameTd, orient, anchor, size2, flags, techBits, protoTd);
            if (this.resultShapeBuilder != null) {
                this.oldTechPool.getPrimitiveNode((PrimitiveNodeId)protoId).genShape(this.resultShapeBuilder, n);
            } else {
                maxSuffix.add(n);
                assert (!this.curNodes.get(nodeId));
                this.curNodes.set(nodeId);
                ++this.curNodesCount;
            }
            rn.setTapConnection(n);
            this.addedNodesToNodeInst.put(rn, n);
        }
        for (SeaOfGatesEngine.RouteArc ra : resolution.arcsToRoute) {
            int arcId = this.curArcs.size();
            protoId = ra.getProtoId();
            assert (this.maxArcSuffix < Integer.MAX_VALUE);
            Name name = null;
            Name newName = null;
            if (ra.getName() != null) {
                newName = Name.findName(ra.getName());
            }
            name = newName != null && !newName.isTempname() ? newName : ImmutableArcInst.BASENAME.findSuffixed(++this.maxArcSuffix);
            nameTd = this.ep.getArcTextDescriptor();
            SeaOfGatesEngine.RouteNode tail = ra.getTail();
            int tailNodeId = tail.exists() ? tail.getNodeId() : this.addedNodesToNodeInst.get((Object)tail).nodeId;
            PortProtoId tailProtoId = tail.getPortProtoId();
            EPoint tailLocation = tail.getLoc();
            SeaOfGatesEngine.RouteNode head2 = ra.getHead();
            int headNodeId = head2.exists() ? head2.getNodeId() : this.addedNodesToNodeInst.get((Object)head2).nodeId;
            PortProtoId headProtoId = head2.getPortProtoId();
            EPoint headLocation = head2.getLoc();
            long gridExtendOverMin = ra.getGridExtendOverMin();
            int angle = -1;
            int flags = ra.getFlags(this.ep);
            ImmutableArcInst a = ImmutableArcInst.newInstance(arcId, protoId, name, nameTd, tailNodeId, tailProtoId, tailLocation, headNodeId, headProtoId, headLocation, gridExtendOverMin, angle, flags);
            if (this.resultShapeBuilder != null) {
                this.resultShapeBuilder.genShapeOfArc(a);
                continue;
            }
            this.curArcs.add(a);
        }
        if (this.resultShapeBuilder != null) {
            return;
        }
        ArcProtoId unroutedId = this.oldTechPool.getGeneric().unrouted_arc.getId();
        long unroutedGridExtend = this.oldTechPool.getGeneric().unrouted_arc.getDefaultInst(this.ep).getGridExtendOverMin();
        int unroutedFlags = this.oldTechPool.getGeneric().unrouted_arc.getDefaultInst((EditingPreferences)this.ep).flags;
        for (SeaOfGatesEngine.RouteAddUnrouted rau : resolution.unroutedToAdd) {
            int arcId = this.curArcs.size();
            ArcProtoId protoId2 = unroutedId;
            assert (this.maxArcSuffix < Integer.MAX_VALUE);
            Name name = ImmutableArcInst.BASENAME.findSuffixed(++this.maxArcSuffix);
            TextDescriptor nameTd2 = this.ep.getArcTextDescriptor();
            int tailNodeId = rau.getTailId();
            PortProtoId tailProtoId = rau.getTailPortProtoId();
            EPoint tailLocation = rau.getTailLocation();
            int headNodeId = rau.getHeadId();
            PortProtoId headProtoId = rau.getHeadPortProtoId();
            EPoint headLocation = rau.getHeadLocation();
            long gridExtendOverMin = unroutedGridExtend;
            int angle = -1;
            int flags = unroutedFlags;
            ImmutableArcInst a = ImmutableArcInst.newInstance(arcId, protoId2, name, nameTd2, tailNodeId, tailProtoId, tailLocation, headNodeId, headProtoId, headLocation, gridExtendOverMin, angle, flags);
            this.curArcs.add(a);
        }
        resolution.clearRoutes();
    }

    private void makeGridBox(long[] gridCoords, EPoint tailLocation, boolean tailExtended, EPoint headLocation, boolean headExtended, long gridExtend) {
        long hy;
        long hx;
        long ly;
        long lx;
        long et = tailExtended ? gridExtend : 0L;
        long eh = headExtended ? gridExtend : 0L;
        int angle = GenMath.figureAngle(tailLocation, headLocation);
        switch (angle) {
            case -1: 
            case 0: {
                long m = tailLocation.getGridY();
                lx = tailLocation.getGridX() - et;
                ly = m - gridExtend;
                hx = headLocation.getGridX() + eh;
                hy = m + gridExtend;
                break;
            }
            case 900: {
                long m = tailLocation.getGridX();
                lx = m - gridExtend;
                ly = tailLocation.getGridY() - et;
                hx = m + gridExtend;
                hy = headLocation.getGridY() + eh;
                break;
            }
            case 1800: {
                long m = tailLocation.getGridY();
                lx = headLocation.getGridX() - eh;
                ly = m - gridExtend;
                hx = tailLocation.getGridX() + et;
                hy = m + gridExtend;
                break;
            }
            case 2700: {
                long m = tailLocation.getGridX();
                lx = m - gridExtend;
                ly = headLocation.getGridY() - eh;
                hx = m + gridExtend;
                hy = tailLocation.getGridY() + et;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        gridCoords[0] = lx;
        gridCoords[1] = ly;
        gridCoords[2] = hx;
        gridCoords[3] = hy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Snapshot commit() {
        ImmutableArcInst[] newArcs;
        ImmutableNodeInst[] newNodes;
        SeaOfGatesCellBuilder seaOfGatesCellBuilder = this;
        synchronized (seaOfGatesCellBuilder) {
            newNodes = new ImmutableNodeInst[this.curNodesCount];
            int oldNodeIndex = 0;
            int newNodeIndex = 0;
            for (MaxNodeSuffix maxSuffix : this.maxNodeSuffixesOrdered.values()) {
                while (oldNodeIndex < maxSuffix.insertionPoint) {
                    ImmutableNodeInst n = this.oldCellRevision.nodes.get(oldNodeIndex++);
                    if (!this.curNodes.get(n.nodeId)) continue;
                    newNodes[newNodeIndex++] = n;
                }
                for (ImmutableNodeInst n : maxSuffix.addedNodes) {
                    assert (this.curNodes.get(n.nodeId));
                    newNodes[newNodeIndex++] = n;
                }
            }
            while (oldNodeIndex < this.oldCellRevision.nodes.size()) {
                ImmutableNodeInst n = this.oldCellRevision.nodes.get(oldNodeIndex++);
                if (!this.curNodes.get(n.nodeId)) continue;
                newNodes[newNodeIndex++] = n;
            }
            assert (newNodeIndex == newNodes.length);
            int arcCount = 0;
            for (ImmutableArcInst a : this.curArcs) {
                if (a == null) continue;
                ++arcCount;
            }
            newArcs = new ImmutableArcInst[arcCount];
            arcCount = 0;
            for (ImmutableArcInst a : this.curArcs) {
                if (a == null) continue;
                newArcs[arcCount++] = a;
            }
            assert (arcCount == newArcs.length);
            Arrays.sort(newArcs, ImmutableArcInst.ARCS_ORDER);
        }
        this.curCellBackups[this.cellId.cellIndex] = this.curCellBackup = this.curCellBackup.with(this.oldCell, newNodes, newArcs, null, this.oldTechPool);
        if (this.resultShapeBuilder != null) {
            this.curCellBackups[((MyShapeBuilder)this.resultShapeBuilder).cellId.cellIndex] = this.resultShapeBuilder.commit();
        }
        this.curSnapshot = this.curSnapshot.with(this.oldTool, this.oldEnvironment, this.curCellBackups, null);
        return this.curSnapshot;
    }

    private int searchNodeInsertionPoint(String basename) {
        assert (basename.endsWith("@0"));
        char nextChar = (char)(basename.charAt(basename.length() - 2) + '\u0001');
        String nextName = basename.substring(0, basename.length() - 2) + nextChar;
        int index = this.oldCellRevision.nodes.searchByName(nextName);
        return index >= 0 ? index : -(index + 1);
    }

    private int searchArcInsertionPoint(String basename) {
        assert (basename.endsWith("@0"));
        char nextChar = (char)(basename.charAt(basename.length() - 2) + '\u0001');
        String nextName = basename.substring(0, basename.length() - 2) + nextChar;
        int index = this.oldCellRevision.arcs.searchByName(nextName);
        return index >= 0 ? index : -(index + 1);
    }

    private static class MaxNodeSuffix {
        final Name basename;
        final int insertionPoint;
        int maxSuffix;
        List<ImmutableNodeInst> addedNodes = new ArrayList<ImmutableNodeInst>();

        private MaxNodeSuffix(SeaOfGatesCellBuilder b, Name basename) {
            Name name;
            this.basename = basename;
            this.insertionPoint = b.searchNodeInsertionPoint(basename.toString());
            this.maxSuffix = -1;
            if (this.insertionPoint > 0 && (name = ((SeaOfGatesCellBuilder)b).oldCellRevision.nodes.get((int)(this.insertionPoint - 1)).name).isTempname() && name.getBasename() == basename) {
                this.maxSuffix = name.getNumSuffix();
            }
        }

        private Name getNextName() {
            return this.basename.findSuffixed(this.maxSuffix + 1);
        }

        private void add(ImmutableNodeInst n) {
            ++this.maxSuffix;
            assert (n.name.getBasename() == this.basename);
            assert (n.name.getNumSuffix() == this.maxSuffix);
            this.addedNodes.add(n);
        }
    }

    private class MyShapeBuilder
    extends AbstractShapeBuilder {
        private final CellId cellId;
        private final TextDescriptor nameTd;
        private final TextDescriptor protoTd;
        private CellBackup cellBackup;
        private final List<ImmutableNodeInst> nodes;

        MyShapeBuilder(CellId cellId) {
            this.nameTd = SeaOfGatesCellBuilder.this.ep.getNodeTextDescriptor();
            this.protoTd = SeaOfGatesCellBuilder.this.ep.getInstanceTextDescriptor();
            this.nodes = new ArrayList<ImmutableNodeInst>();
            this.setup(SeaOfGatesCellBuilder.this.oldTechPool);
            this.cellId = cellId;
            Date creationDate = new Date();
            ImmutableCell resultCell = ImmutableCell.newInstance(cellId, creationDate.getTime()).withTechId(((SeaOfGatesCellBuilder)SeaOfGatesCellBuilder.this).oldCellBackup.cellRevision.d.techId);
            this.cellBackup = CellBackup.newInstance(resultCell, SeaOfGatesCellBuilder.this.oldTechPool);
        }

        @Override
        protected void addPoly(int numPoints, Poly.Type style, Layer layer, EGraphics graphicsOverride, PrimitivePort pp) {
            assert (style == Poly.Type.CROSSED && numPoints > 0);
            long fixpLX = Long.MAX_VALUE;
            long fixpLY = Long.MAX_VALUE;
            long fixpHX = Long.MIN_VALUE;
            long fixpHY = Long.MIN_VALUE;
            for (int i = 0; i < numPoints; ++i) {
                long x2 = this.coords[i * 2];
                long y = this.coords[i * 2 + 1];
                fixpLX = Math.min(fixpLX, x2);
                fixpLY = Math.min(fixpLY, y);
                fixpHX = Math.max(fixpHX, x2);
                fixpHY = Math.max(fixpHY, y);
            }
            assert (fixpLX <= fixpHX && fixpLY <= fixpHY);
            int nodeId = this.nodes.size();
            PrimitiveNodeId protoId = layer.getPureLayerNode().getId();
            Name name = Name.findName("plnode@" + nodeId);
            EPoint anchor = EPoint.fromFixp(fixpLX + fixpHX >> 1, fixpLY + fixpHY >> 1);
            EPoint size2 = EPoint.fromFixp(fixpHX - fixpLX, fixpHY - fixpLY);
            this.nodes.add(ImmutableNodeInst.newInstance(nodeId, protoId, name, this.nameTd, Orientation.IDENT, anchor, size2, 0, 0, this.protoTd));
        }

        @Override
        protected void addBox(Layer layer) {
            int nodeId = this.nodes.size();
            PrimitiveNodeId protoId = layer.getPureLayerNode().getId();
            Name name = Name.findName("plnode@" + nodeId);
            long fixpLX = this.coords[0];
            long fixpLY = this.coords[1];
            long fixpHX = this.coords[2];
            long fixpHY = this.coords[3];
            EPoint anchor = EPoint.fromFixp(fixpLX + fixpHX >> 1, fixpLY + fixpHY >> 1);
            EPoint size2 = EPoint.fromFixp(fixpHX - fixpLX, fixpHY - fixpLY);
            this.nodes.add(ImmutableNodeInst.newInstance(nodeId, protoId, name, this.nameTd, Orientation.IDENT, anchor, size2, 0, 0, this.protoTd));
        }

        CellBackup commit() {
            this.cellBackup = this.cellBackup.with(this.cellBackup.cellRevision.d, this.nodes.toArray(new ImmutableNodeInst[this.nodes.size()]), null, null, SeaOfGatesCellBuilder.this.oldTechPool);
            return this.cellBackup;
        }
    }
}

