/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Equipment;
import com.sun.electric.tool.simulation.test.Infrastructure;

public class T2500
extends Equipment {
    public T2500(String name) {
        super(name);
        T2500.logInit("Initialized T2500 Temperature Forcer named " + name);
    }

    public float getAirTemp() {
        this.write("AIRTEMP?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public float getDeviceTemp() {
        this.write("DUTTEMP?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public float getSoakTime() {
        this.write("SOAKTIME?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public float getSetpoint() {
        this.write("SETPOINT?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public float getStatus() {
        this.write("TESR?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public boolean getHeadState() {
        this.write("HEAD?");
        String[] s = this.read(40).split(" ");
        return Boolean.valueOf(s[0]);
    }

    public void headDown(boolean state) {
        if (state) {
            this.write("HEAD 0");
        } else {
            this.write("HEAD 1");
        }
    }

    public boolean getCompressorState() {
        this.write("COMP?");
        String[] s = this.read(40).split(" ");
        return Boolean.valueOf(s[0]);
    }

    public void setCompressorState(boolean state) {
        if (state) {
            this.write("COMP 1");
        } else {
            this.write("COMP 0");
        }
    }

    public void setTemp(int presetNum, float value2) {
        this.write("TEMP" + presetNum + " " + value2);
    }

    public float getTemp(int presetNum) {
        this.write("TEMP" + presetNum + "?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public void goTemp(int presetNum) {
        this.write("GOTEMP" + presetNum);
    }

    public void setSoakTime(int presetNum, float soakTime) {
        this.write("SOAK" + presetNum + " " + soakTime);
    }

    public float getSoakTime(int presetNum) {
        this.write("SOAK" + presetNum + "?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public void airOff() {
        this.write("AIROFF");
    }

    public void setBoost(int level) {
        this.write("BOOST " + level);
    }

    public float getBoostLevel() {
        this.write("BOOST?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public void setColdFlow(int value2) {
        this.write("COLDFLOW " + value2);
    }

    public float getColdFlow() {
        this.write("COLDFLOW?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public void setHotFlow(int value2) {
        this.write("HOTFLOW " + value2);
    }

    public float getHotFlow() {
        this.write("HOTFLOW?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public void setRampState(boolean state) {
        if (state) {
            this.write("RAMP 1");
        } else {
            this.write("RAMP 0");
        }
    }

    public boolean getRampState() {
        this.write("RAMP?");
        String[] s = this.read(40).split(" ");
        return Boolean.valueOf(s[0]);
    }

    public void setRampRate(int value2) {
        this.write("RAMPRATE " + value2);
    }

    public float getRampRate() {
        this.write("RAMPRATE?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public void setTempSensing(int value2) {
        this.write("TCONTROL " + value2);
    }

    public float getTempSensingMode() {
        this.write("TCONTROL?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public void setTempTolerance(float value2) {
        this.write("TEMPTOL " + value2);
    }

    public float getTempTol() {
        this.write("TEMPTOL?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public void setMinTemp(float value2) {
        this.write("MINTEMP " + value2);
    }

    public float getMinTemp() {
        this.write("MINTEMP?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public void setMaxTemp(float value2) {
        this.write("MAXTEMP " + value2);
    }

    public float getMaxTemp() {
        this.write("MAXTEMP?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public String test() {
        this.write("FLOW?");
        return this.read(40);
    }

    public float getFlow() {
        this.write("FLOW?");
        String[] s = this.read(40).split(" ");
        return Float.parseFloat(s[0]);
    }

    public static void main(String[] args) {
        int[] gpibController = new int[]{0};
        Infrastructure.gpibControllers = gpibController;
        T2500 DUT = new T2500("T2500");
        DUT.airOff();
        DUT.setMaxTemp(150.0f);
        DUT.setMinTemp(-60.0f);
        System.out.println("Min Temp: " + DUT.getMinTemp());
        System.out.println("Max Temp: " + DUT.getMaxTemp());
    }
}

