/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.dtbook;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.dtbook.DTBookHandler;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;

public class DTBookChecker
implements ContentChecker {
    OCFPackage ocf;
    Report report;
    String path;
    XRefChecker xrefChecker;
    static XMLValidator dtbookValidator = new XMLValidator("rng/dtbook-2005-2.rng");

    public DTBookChecker(OCFPackage ocf, Report report, String path, XRefChecker xrefChecker) {
        this.ocf = ocf;
        this.report = report;
        this.path = path;
        this.xrefChecker = xrefChecker;
    }

    public void runChecks() {
        if (!this.ocf.hasEntry(this.path)) {
            this.report.error(null, 0, "DTBook file " + this.path + " is missing");
        } else if (!this.ocf.canDecrypt(this.path)) {
            this.report.error(null, 0, "DTBook file " + this.path + " cannot be decrypted");
        } else {
            XMLParser dtbookParser = new XMLParser(this.ocf, this.path, this.report);
            dtbookParser.addValidator(dtbookValidator);
            DTBookHandler dtbookHandler = new DTBookHandler(dtbookParser, this.path, this.xrefChecker);
            dtbookParser.addXMLHandler(dtbookHandler);
            dtbookParser.process();
        }
    }
}

