/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.dtbook;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.dtbook.DTBookHandler;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Preconditions;

public class DTBookChecker
implements ContentChecker {
    private final ValidationContext context;
    private final Report report;
    private final String path;

    public DTBookChecker(ValidationContext context) {
        Preconditions.checkState("application/x-dtbook+xml".equals(context.mimeType));
        this.context = context;
        this.report = context.report;
        this.path = context.path;
    }

    @Override
    public void runChecks() {
        OCFPackage ocf = this.context.ocf.get();
        if (!ocf.hasEntry(this.path)) {
            this.report.message(MessageId.RSC_001, EPUBLocation.create(ocf.getName()), this.path);
        } else if (!ocf.canDecrypt(this.path)) {
            this.report.message(MessageId.RSC_004, EPUBLocation.create(ocf.getName()), this.path);
        } else {
            XMLParser dtbookParser = new XMLParser(this.context);
            dtbookParser.addValidator(XMLValidators.DTBOOK_RNG.get());
            DTBookHandler dtbookHandler = new DTBookHandler(dtbookParser, this.path, this.context.xrefChecker.get());
            dtbookParser.addXMLHandler(dtbookHandler);
            dtbookParser.process();
        }
    }
}

