/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.FanInt;
import fan.sys.Locale;
import fan.sys.NumDigits;
import fan.sys.NumPattern;
import fan.sys.Sys;
import fan.sys.Type;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;

public class FanNum {
    public static long toInt(Number number) {
        return number.longValue();
    }

    public static double toFloat(Number number) {
        return number.doubleValue();
    }

    public static BigDecimal toDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal(number.longValue());
        }
        return new BigDecimal(number.doubleValue());
    }

    public static Type typeof(Number number) {
        return Sys.NumType;
    }

    public static String localeDecimal() {
        return FanInt.toChar(Locale.cur().decimal().getDecimalSeparator());
    }

    public static String localeGrouping() {
        return FanInt.toChar(Locale.cur().decimal().getGroupingSeparator());
    }

    public static String localeMinus() {
        return FanInt.toChar(Locale.cur().decimal().getMinusSign());
    }

    public static String localePercent() {
        return FanInt.toChar(Locale.cur().decimal().getPercent());
    }

    public static String localePosInf() {
        return Locale.cur().decimal().getInfinity();
    }

    public static String localeNegInf() {
        Locale locale = Locale.cur();
        return locale.decimal().getMinusSign() + locale.decimal().getInfinity();
    }

    public static String localeNaN() {
        return Locale.cur().decimal().getNaN();
    }

    static String toLocale(NumPattern numPattern, NumDigits numDigits, DecimalFormatSymbols decimalFormatSymbols) {
        int n;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        if (numDigits.negative) {
            stringBuilder.append(decimalFormatSymbols.getMinusSign());
        }
        numDigits.round(numPattern.maxFrac);
        int n3 = 0;
        if (numPattern.optInt && numDigits.zeroInt()) {
            n3 = numDigits.decimal;
        }
        if (numPattern.minFrac == 0 && numDigits.zeroFrac(numPattern.maxFrac)) {
            numDigits.size = numDigits.decimal;
        }
        for (n2 = 0; n2 < numPattern.minInt - numDigits.decimal; ++n2) {
            stringBuilder.append('0');
        }
        n2 = 0;
        for (n = n3; n < numDigits.size; ++n) {
            if (n < numDigits.decimal) {
                if ((numDigits.decimal - n) % numPattern.group == 0 && n > 0) {
                    stringBuilder.append(decimalFormatSymbols.getGroupingSeparator());
                }
            } else {
                if (n == numDigits.decimal && numPattern.maxFrac > 0) {
                    stringBuilder.append(decimalFormatSymbols.getDecimalSeparator());
                    n2 = 1;
                }
                if (n - numDigits.decimal >= numPattern.maxFrac) break;
            }
            stringBuilder.append(numDigits.digits[n]);
        }
        for (n = 0; n < numPattern.minFrac - numDigits.fracSize(); ++n) {
            if (n2 == 0) {
                stringBuilder.append(decimalFormatSymbols.getDecimalSeparator());
                n2 = 1;
            }
            stringBuilder.append('0');
        }
        if (stringBuilder.length() == 0) {
            return "0";
        }
        return stringBuilder.toString();
    }
}

