/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.Buf;
import fan.sys.DateTime;
import fan.sys.FanInt;
import fan.sys.FanObj;
import fan.sys.Func;
import fan.sys.IOErr;
import fan.sys.InStream;
import fan.sys.List;
import fan.sys.LocalFile;
import fan.sys.Map;
import fan.sys.MimeType;
import fan.sys.OutStream;
import fan.sys.Regex;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.Uri;
import java.io.IOException;

public abstract class File
extends FanObj {
    public static final String sep = java.io.File.separator;
    public static final String pathSep = java.io.File.pathSeparator;
    Uri uri;

    public static File make(Uri uri) {
        return File.make(uri, true);
    }

    public static File make(Uri uri, boolean bl) {
        java.io.File file = LocalFile.uriToFile(uri);
        if (file.isDirectory() && !bl && !uri.isDir()) {
            uri = uri.plusSlash();
        }
        return new LocalFile(uri, file);
    }

    public static File os(String string) {
        return new LocalFile(new java.io.File(string));
    }

    public static List osRoots() {
        List list = new List(Sys.FileType);
        java.io.File[] fileArray = java.io.File.listRoots();
        for (int i = 0; i < fileArray.length; ++i) {
            list.add(new LocalFile(fileArray[i], true));
        }
        return list;
    }

    public static File createTemp() {
        return File.createTemp(null, null, null);
    }

    public static File createTemp(String string) {
        return File.createTemp(string, null, null);
    }

    public static File createTemp(String string, String string2) {
        return File.createTemp(string, string2, null);
    }

    public static File createTemp(String string, String string2, File file) {
        if (string == null || string.length() == 0) {
            string = "fan";
        }
        if (string.length() == 1) {
            string = string + "xx";
        }
        if (string.length() == 2) {
            string = string + "x";
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        java.io.File file2 = null;
        if (file != null) {
            if (!(file instanceof LocalFile)) {
                throw IOErr.make("Dir is not on local file system: " + file);
            }
            file2 = ((LocalFile)file).file;
        }
        try {
            return new LocalFile(java.io.File.createTempFile(string, string2, file2));
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    protected static void makeNew$(File file, Uri uri) {
        file.uri = uri;
    }

    protected File(Uri uri) {
        this.uri = uri;
    }

    protected File() {
    }

    public final boolean equals(Object object) {
        if (object instanceof File) {
            return this.uri.equals(((File)object).uri);
        }
        return false;
    }

    public final int hashCode() {
        return this.uri.hashCode();
    }

    public final long hash() {
        return this.uri.hash();
    }

    public final String toStr() {
        return this.uri.toStr();
    }

    public Type typeof() {
        return Sys.FileType;
    }

    public final Uri uri() {
        return this.uri;
    }

    public final boolean isDir() {
        return this.uri.isDir();
    }

    public final List path() {
        return this.uri.path();
    }

    public final String pathStr() {
        return this.uri.pathStr();
    }

    public final String name() {
        return this.uri.name();
    }

    public final String basename() {
        return this.uri.basename();
    }

    public final String ext() {
        return this.uri.ext();
    }

    public final MimeType mimeType() {
        return this.uri.mimeType();
    }

    public abstract boolean exists();

    public abstract Long size();

    public abstract DateTime modified();

    public abstract void modified(DateTime var1);

    public abstract String osPath();

    public abstract File parent();

    public abstract List list();

    public List listDirs() {
        List list = this.list();
        for (int i = list.sz() - 1; i >= 0; --i) {
            if (((File)list.get(i)).isDir()) continue;
            list.removeAt(i);
        }
        return list;
    }

    public List listFiles() {
        List list = this.list();
        for (int i = list.sz() - 1; i >= 0; --i) {
            if (!((File)list.get(i)).isDir()) continue;
            list.removeAt(i);
        }
        return list;
    }

    public void walk(Func func) {
        func.call(this);
        if (this.isDir()) {
            List list = this.list();
            for (int i = 0; i < list.sz(); ++i) {
                ((File)list.get(i)).walk(func);
            }
        }
    }

    public abstract File normalize();

    public File plus(Uri uri) {
        return this.plus(uri, true);
    }

    public abstract File plus(Uri var1, boolean var2);

    File plus(String string) {
        return this.plus(Uri.fromStr(string));
    }

    File plusNameOf(File file) {
        String string = file.name();
        if (file.isDir()) {
            string = string + "/";
        }
        return this.plus(string);
    }

    public abstract File create();

    public File createFile(String string) {
        if (!this.isDir()) {
            throw IOErr.make("Not a directory: " + this);
        }
        return this.plus(Uri.fromStr(string)).create();
    }

    public File createDir(String string) {
        if (!this.isDir()) {
            throw IOErr.make("Not a directory: " + this);
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        return this.plus(Uri.fromStr(string)).create();
    }

    public abstract void delete();

    public abstract File deleteOnExit();

    public final File copyTo(File file) {
        return this.copyTo(file, null);
    }

    public File copyTo(File file, Map map) {
        if (this.isDir() != file.isDir()) {
            if (this.isDir()) {
                throw ArgErr.make("copyTo must be dir `" + file + "`");
            }
            throw ArgErr.make("copyTo must not be dir `" + file + "`");
        }
        Object object = null;
        Object object2 = null;
        if (map != null) {
            object = map.get("exclude");
            object2 = map.get("overwrite");
        }
        this.doCopyTo(file, object, object2);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyTo(File file, Object object, Object object2) {
        if (object instanceof Regex ? ((Regex)object).matches(this.uri.toStr()) : object instanceof Func && ((Func)object).callBool(this)) {
            return;
        }
        if (file.exists()) {
            if (object2 instanceof Boolean) {
                if (!((Boolean)object2).booleanValue()) {
                    return;
                }
            } else if (object2 instanceof Func) {
                if (!((Func)object2).callBool(this)) {
                    return;
                }
            } else {
                throw IOErr.make("No overwrite policy for `" + file + "`");
            }
        }
        if (this.isDir()) {
            file.create();
            List list = this.list();
            for (int i = 0; i < list.sz(); ++i) {
                File file2 = (File)list.get(i);
                file2.doCopyTo(file.plusNameOf(file2), object, object2);
            }
        } else {
            OutStream outStream = file.out();
            try {
                this.in().pipe(outStream);
            }
            finally {
                outStream.close();
            }
            File.copyPermissions(this, file);
        }
    }

    public final File copyInto(File file) {
        return this.copyInto(file, null);
    }

    public File copyInto(File file, Map map) {
        if (!file.isDir()) {
            throw ArgErr.make("Not a dir: `" + file + "`");
        }
        return this.copyTo(file.plusNameOf(this), map);
    }

    private static void copyPermissions(File file, File file2) {
        try {
            if (file instanceof LocalFile && file2 instanceof LocalFile) {
                java.io.File file3 = ((LocalFile)file).file;
                java.io.File file4 = ((LocalFile)file2).file;
                file4.setReadable(file3.canRead(), false);
                file4.setWritable(file3.canWrite(), false);
                file4.setExecutable(file3.canExecute(), false);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public abstract File moveTo(File var1);

    public File moveInto(File file) {
        if (!file.isDir()) {
            throw ArgErr.make("Not a dir: `" + file + "`");
        }
        return this.moveTo(file.plusNameOf(this));
    }

    public File rename(String string) {
        File file;
        if (this.isDir()) {
            string = string + "/";
        }
        if ((file = this.parent()) == null) {
            return this.moveTo(File.make(Uri.fromStr(string)));
        }
        return this.moveTo(file.plus(string));
    }

    public Buf open() {
        return this.open("rw");
    }

    public abstract Buf open(String var1);

    public Buf mmap() {
        return this.mmap("rw", 0L, null);
    }

    public Buf mmap(String string) {
        return this.mmap(string, 0L, null);
    }

    public Buf mmap(String string, long l) {
        return this.mmap(string, l, null);
    }

    public abstract Buf mmap(String var1, long var2, Long var4);

    public InStream in() {
        return this.in(FanInt.Chunk);
    }

    public abstract InStream in(Long var1);

    public OutStream out() {
        return this.out(false, FanInt.Chunk);
    }

    public OutStream out(boolean bl) {
        return this.out(bl, FanInt.Chunk);
    }

    public abstract OutStream out(boolean var1, Long var2);

    public final Buf readAllBuf() {
        return this.in(FanInt.Chunk).readAllBuf();
    }

    public final List readAllLines() {
        return this.in(FanInt.Chunk).readAllLines();
    }

    public final void eachLine(Func func) {
        this.in(FanInt.Chunk).eachLine(func);
    }

    public final String readAllStr() {
        return this.readAllStr(true);
    }

    public final String readAllStr(boolean bl) {
        return this.in(FanInt.Chunk).readAllStr(bl);
    }

    public final Map readProps() {
        return this.in(FanInt.Chunk).readProps();
    }

    public final void writeProps(Map map) {
        this.out(false, FanInt.Chunk).writeProps(map, true);
    }

    public final Object readObj() {
        return this.readObj(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object readObj(Map map) {
        InStream inStream = this.in();
        try {
            Object object = inStream.readObj(map);
            return object;
        }
        finally {
            inStream.close();
        }
    }

    public final void writeObj(Object object) {
        this.writeObj(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeObj(Object object, Map map) {
        OutStream outStream = this.out();
        try {
            outStream.writeObj(object, map);
        }
        finally {
            outStream.close();
        }
    }
}

