/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.Buf;
import fan.sys.FanInt;
import fan.sys.File;
import fan.sys.IOErr;
import fan.sys.InStream;
import fan.sys.MemBuf;
import fan.sys.OutStream;
import fan.sys.Sys;
import fan.sys.Type;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileBuf
extends Buf {
    private File file;
    private RandomAccessFile fp;
    private byte[] temp;

    FileBuf(File file, RandomAccessFile randomAccessFile) {
        this.file = file;
        this.fp = randomAccessFile;
        this.out = new FileBufOutStream();
        this.in = new FileBufInStream();
    }

    public Type typeof() {
        return Sys.FileBufType;
    }

    public final long size() {
        try {
            return this.fp.length();
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public final void size(long l) {
        try {
            this.fp.setLength(l);
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public final long pos() {
        try {
            return this.fp.getFilePointer();
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    final void pos(long l) {
        try {
            this.fp.seek(l);
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public final int getByte(long l) {
        try {
            long l2 = this.fp.getFilePointer();
            this.fp.seek(l);
            int n = this.fp.read();
            this.fp.seek(l2);
            return n;
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public final void setByte(long l, int n) {
        try {
            long l2 = this.fp.getFilePointer();
            this.fp.seek(l);
            this.fp.write(n);
            this.fp.seek(l2);
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public final void getBytes(long l, byte[] byArray, int n, int n2) {
        try {
            this.fp.seek(l);
            this.fp.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public final void pipeTo(byte[] byArray, int n, int n2) {
        try {
            this.fp.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public final void pipeTo(OutputStream outputStream, long l) throws IOException {
        int n;
        byte[] byArray = this.temp();
        for (long i = 0L; i < l; i += (long)n) {
            n = this.fp.read(byArray, 0, (int)Math.min((long)byArray.length, l - i));
            outputStream.write(byArray, 0, n);
        }
    }

    public final void pipeTo(RandomAccessFile randomAccessFile, long l) throws IOException {
        int n;
        byte[] byArray = this.temp();
        for (long i = 0L; i < l; i += (long)n) {
            n = this.fp.read(byArray, 0, (int)Math.min((long)byArray.length, l - i));
            randomAccessFile.write(byArray, 0, n);
        }
    }

    public final void pipeTo(ByteBuffer byteBuffer, int n) {
        try {
            int n2;
            byte[] byArray = this.temp();
            for (int i = 0; i < n; i += n2) {
                n2 = this.fp.read(byArray, 0, Math.min(byArray.length, n - i));
                byteBuffer.put(byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public final void pipeFrom(byte[] byArray, int n, int n2) {
        try {
            this.fp.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public final long pipeFrom(InputStream inputStream, long l) throws IOException {
        long l2;
        int n;
        byte[] byArray = this.temp();
        for (l2 = 0L; l2 < l; l2 += (long)n) {
            n = inputStream.read(byArray, 0, (int)Math.min((long)byArray.length, l - l2));
            if (n < 0) {
                return l2 == 0L ? -1L : l2;
            }
            this.fp.write(byArray, 0, n);
        }
        return l2;
    }

    public final long pipeFrom(RandomAccessFile randomAccessFile, long l) throws IOException {
        long l2;
        int n;
        byte[] byArray = this.temp();
        for (l2 = 0L; l2 < l; l2 += (long)n) {
            n = randomAccessFile.read(byArray, 0, (int)Math.min((long)byArray.length, l - l2));
            if (n < 0) {
                return l2 == 0L ? -1L : l2;
            }
            this.fp.write(byArray, 0, n);
        }
        return l2;
    }

    public final int pipeFrom(ByteBuffer byteBuffer, int n) {
        try {
            int n2;
            int n3;
            byte[] byArray = this.temp();
            for (n2 = 0; n2 < n; n2 += n3) {
                n3 = Math.min(byArray.length, n - n2);
                byteBuffer.get(byArray, 0, n3);
                this.fp.write(byArray, 0, n3);
            }
            return n2;
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public final Buf flush() {
        try {
            this.fp.getFD().sync();
            return this;
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public final boolean close() {
        try {
            this.fp.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public final String toHex() {
        try {
            int n;
            long l = this.pos();
            int n2 = (int)this.size();
            byte[] byArray = this.temp();
            char[] cArray = Buf.hexChars;
            StringBuilder stringBuilder = new StringBuilder(n2 * 2);
            this.pos(0L);
            for (int i = 0; i < n2; i += n) {
                n = this.fp.read(byArray, 0, Math.min(byArray.length, n2 - i));
                for (int j = 0; j < n; ++j) {
                    int n3 = byArray[j] & 0xFF;
                    stringBuilder.append(cArray[n3 >> 4]).append(cArray[n3 & 0xF]);
                }
            }
            this.pos(l);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public Buf toDigest(String string) {
        try {
            int n;
            long l = this.pos();
            long l2 = this.size();
            byte[] byArray = this.temp();
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            this.pos(0L);
            for (long i = 0L; i < l2; i += (long)n) {
                n = this.fp.read(byArray, 0, (int)Math.min((long)byArray.length, (long)((int)l2) - i));
                messageDigest.update(byArray, 0, n);
            }
            this.pos(l);
            return new MemBuf(messageDigest.digest());
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw ArgErr.make("Unknown digest algorthm: " + string);
        }
    }

    final byte[] temp() {
        byte[] byArray = this.temp;
        if (byArray == null) {
            byArray = this.temp = new byte[1024];
        }
        return byArray;
    }

    class FileBufInStream
    extends InStream {
        FileBufInStream() {
        }

        public Long read() {
            int n = this.r();
            return n < 0 ? null : FanInt.pos[n];
        }

        public int r() {
            try {
                return FileBuf.this.fp.read();
            }
            catch (IOException iOException) {
                throw IOErr.make(iOException);
            }
        }

        public Long readBuf(Buf buf, long l) {
            try {
                long l2 = buf.pipeFrom(FileBuf.this.fp, l);
                if (l2 < 0L) {
                    return null;
                }
                return l2;
            }
            catch (IOException iOException) {
                throw IOErr.make(iOException);
            }
        }

        public InStream unread(long l) {
            return this.unread((int)l);
        }

        public InStream unread(int n) {
            try {
                long l = FileBuf.this.pos();
                FileBuf.this.fp.seek(l - 1L);
                FileBuf.this.fp.write(n);
                FileBuf.this.fp.seek(l - 1L);
                return this;
            }
            catch (IOException iOException) {
                throw IOErr.make(iOException);
            }
        }

        public Long peek() {
            try {
                long l = FileBuf.this.pos();
                int n = FileBuf.this.fp.read();
                FileBuf.this.pos(l);
                return n < 0 ? null : FanInt.pos[n];
            }
            catch (IOException iOException) {
                throw IOErr.make(iOException);
            }
        }
    }

    class FileBufOutStream
    extends OutStream {
        FileBufOutStream() {
        }

        public final OutStream write(long l) {
            return this.w((int)l);
        }

        public final OutStream w(int n) {
            try {
                FileBuf.this.fp.write(n);
                return this;
            }
            catch (IOException iOException) {
                throw IOErr.make(iOException);
            }
        }

        public OutStream writeBuf(Buf buf, long l) {
            try {
                buf.pipeTo(FileBuf.this.fp, l);
                return this;
            }
            catch (IOException iOException) {
                throw IOErr.make(iOException);
            }
        }

        public OutStream writeChar(long l) {
            this.charsetEncoder.encode((char)l, this);
            return this;
        }

        public OutStream writeChar(char c) {
            this.charsetEncoder.encode(c, this);
            return this;
        }

        public OutStream flush() {
            FileBuf.this.flush();
            return this;
        }
    }
}

