/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.FanInt;
import fan.sys.FanObj;
import fan.sys.FanStr;
import fan.sys.List;
import fan.sys.RegexMatcher;
import fan.sys.Sys;
import fan.sys.Type;
import java.util.regex.Pattern;

public final class Regex
extends FanObj {
    private String source;
    private Pattern pattern;

    public static Regex fromStr(String string) {
        return new Regex(string);
    }

    public static Regex glob(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (FanInt.isAlphaNum(c)) {
                stringBuilder.append(c);
                continue;
            }
            if (c == '?') {
                stringBuilder.append('.');
                continue;
            }
            if (c == '*') {
                stringBuilder.append('.').append('*');
                continue;
            }
            stringBuilder.append('\\').append(c);
        }
        return new Regex(stringBuilder.toString());
    }

    Regex(String string) {
        this.source = string;
        this.pattern = Pattern.compile(string);
    }

    public final boolean equals(Object object) {
        if (object instanceof Regex) {
            return ((Regex)object).source.equals(this.source);
        }
        return false;
    }

    public final int hashCode() {
        return this.source.hashCode();
    }

    public final long hash() {
        return FanStr.hash(this.source);
    }

    public String toStr() {
        return this.source;
    }

    public Type typeof() {
        return Sys.RegexType;
    }

    public boolean matches(String string) {
        return this.pattern.matcher(string).matches();
    }

    public RegexMatcher matcher(String string) {
        return new RegexMatcher(this.pattern.matcher(string));
    }

    public List split(String string) {
        return this.split(string, 0L);
    }

    public List split(String string, long l) {
        return new List(this.pattern.split(string, (int)l));
    }
}

