/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.DateTime;
import fan.sys.Duration;
import fan.sys.Env;
import fan.sys.FanObj;
import fan.sys.IOErr;
import fan.sys.List;
import fan.sys.Map;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.Uri;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class TimeZone
extends FanObj {
    static File dbFile = new File(Sys.homeDir, "etc" + File.separator + "sys" + File.separator + "timezones.ftz");
    static String[] prefixes = new String[0];
    static byte[] indexPrefixes = new byte[0];
    static String[] indexNames = new String[0];
    static int[] indexOffsets = new int[0];
    static HashMap aliases;
    static HashMap cache;
    static TimeZone utc;
    static TimeZone rel;
    static TimeZone cur;
    private String name;
    private String fullName;
    private Rule[] rules;

    public static List listNames() {
        return new List(Sys.StrType, indexNames).ro();
    }

    public static List listFullNames() {
        List list = new List(Sys.StrType);
        for (int i = 0; i < indexNames.length; ++i) {
            String string = prefixes[indexPrefixes[i] & 0xFF];
            String string2 = indexNames[i];
            if (string.length() != 0) {
                string2 = string + "/" + string2;
            }
            list.add(string2);
        }
        return list.ro();
    }

    public static TimeZone fromStr(String string) {
        return TimeZone.fromStr(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeZone fromStr(String string, boolean bl) {
        TimeZone timeZone;
        Object object = cache;
        synchronized (object) {
            timeZone = (TimeZone)cache.get(string);
            if (timeZone != null) {
                return timeZone;
            }
        }
        try {
            timeZone = TimeZone.loadTimeZone(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw IOErr.make("Cannot load from timezone database: " + string);
        }
        if (timeZone == null) {
            if (aliases == null) {
                TimeZone.loadAliases();
            }
            if ((object = (String)aliases.get(string)) != null) {
                timeZone = TimeZone.fromStr((String)object);
                HashMap hashMap = cache;
                synchronized (hashMap) {
                    cache.put(string, timeZone);
                    return timeZone;
                }
            }
        }
        if (timeZone != null) {
            object = cache;
            synchronized (object) {
                cache.put(timeZone.name, timeZone);
                cache.put(timeZone.fullName, timeZone);
                return timeZone;
            }
        }
        if (bl) {
            throw ParseErr.make("TimeZone not found: " + string);
        }
        return null;
    }

    public static TimeZone defVal() {
        return utc;
    }

    public static TimeZone utc() {
        return utc;
    }

    public static TimeZone rel() {
        return rel;
    }

    public static TimeZone cur() {
        return cur;
    }

    static TimeZone fromGmtOffset(int n) {
        if (n == 0) {
            return TimeZone.utc();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            n = -n;
            stringBuffer.append("GMT+");
        } else {
            stringBuffer.append("GMT-");
        }
        int n2 = n / 3600;
        stringBuffer.append(n2);
        return TimeZone.fromStr(stringBuffer.toString());
    }

    public String toStr() {
        return this.name;
    }

    public Type typeof() {
        return Sys.TimeZoneType;
    }

    public Object trap(String string, List list) {
        if (string.equals("rules")) {
            return this.rules();
        }
        return super.trap(string, list);
    }

    public String name() {
        return this.name;
    }

    public String fullName() {
        return this.fullName;
    }

    public Duration offset(long l) {
        return Duration.make((long)this.rule((int)((int)l)).offset * 1000000000L);
    }

    public Duration dstOffset(long l) {
        Rule rule = this.rule((int)l);
        if (rule.dstOffset == 0) {
            return null;
        }
        return Duration.make((long)rule.dstOffset * 1000000000L);
    }

    public String stdAbbr(long l) {
        return this.rule((int)((int)l)).stdAbbr;
    }

    public String dstAbbr(long l) {
        return this.rule((int)((int)l)).dstAbbr;
    }

    public String abbr(int n, boolean bl) {
        return bl ? this.rule((int)n).dstAbbr : this.rule((int)n).stdAbbr;
    }

    final Rule rule(int n) {
        Rule rule = this.rules[0];
        if (n >= rule.startYear) {
            return rule;
        }
        for (int i = 1; i < this.rules.length; ++i) {
            rule = this.rules[i];
            if (n < rule.startYear) continue;
            return rule;
        }
        return this.rules[this.rules.length - 1];
    }

    private List rules() {
        List list = new List(Sys.ObjType);
        for (int i = 0; i < this.rules.length; ++i) {
            Rule rule = this.rules[i];
            Map map = new Map(Sys.StrType, Sys.ObjType);
            map.set("startYear", rule.startYear);
            map.set("offset", rule.offset);
            map.set("stdAbbr", rule.stdAbbr);
            map.set("dstOffset", rule.dstOffset);
            if (rule.dstOffset != 0) {
                map.set("dstAbbr", rule.dstAbbr);
                map.set("dstStart", this.dstTimeToMap(rule.dstStart));
                map.set("dstEnd", this.dstTimeToMap(rule.dstEnd));
            }
            list.add(map);
        }
        return list;
    }

    private Map dstTimeToMap(DstTime dstTime) {
        Map map = new Map(Sys.StrType, Sys.ObjType);
        map.set("mon", dstTime.mon);
        map.set("onMode", dstTime.onMode);
        map.set("onWeekday", dstTime.onWeekday);
        map.set("onDay", dstTime.onDay);
        map.set("atTime", dstTime.atTime);
        map.set("atMode", dstTime.atMode);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadAliases() {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            object = File.separator;
            Map map = Env.cur().props(Sys.sysPod, Uri.fromStr("timezone-aliases.props"), Duration.Zero);
            Iterator iterator = map.pairsIterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                hashMap.put(string, string2);
                int n = string.lastIndexOf(47);
                if (n <= 0) continue;
                hashMap.put(string.substring(n + 1), string2);
            }
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: Cannot read timezone-aliases.props");
            throwable.printStackTrace();
        }
        aliases = hashMap;
        object = aliases;
        synchronized (object) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadIndex() throws IOException {
        DataInputStream dataInputStream = TimeZone.openDb();
        try {
            int n;
            long l = dataInputStream.readLong();
            if (l != 7377299111153774642L) {
                throw new IOException("Invalid magic 0x" + Long.toHexString(l));
            }
            String string = dataInputStream.readUTF();
            int n2 = dataInputStream.readUnsignedByte();
            prefixes = new String[n2];
            for (n = 0; n < n2; ++n) {
                TimeZone.prefixes[n] = dataInputStream.readUTF();
            }
            n = dataInputStream.readUnsignedShort();
            indexPrefixes = new byte[n];
            indexNames = new String[n];
            indexOffsets = new int[n];
            for (int i = 0; i < n; ++i) {
                TimeZone.indexPrefixes[i] = (byte)dataInputStream.read();
                TimeZone.indexNames[i] = dataInputStream.readUTF();
                TimeZone.indexOffsets[i] = dataInputStream.readInt();
                if (i == 0 || indexNames[i - 1].compareTo(indexNames[i]) < 0) continue;
                throw new IOException("Index not sorted");
            }
        }
        finally {
            dataInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TimeZone loadTimeZone(String string) throws IOException {
        int n;
        String string2 = string;
        int n2 = string.lastIndexOf(47);
        if (n2 > 0) {
            string2 = string2.substring(n2 + 1);
        }
        if ((n = Arrays.binarySearch(indexNames, string2)) < 0) {
            return null;
        }
        String string3 = string2;
        String string4 = prefixes[indexPrefixes[n] & 0xFF];
        if (string4.length() != 0) {
            string3 = string4 + "/" + string2;
        }
        if (n2 > 0 && !string.equals(string3)) {
            return null;
        }
        TimeZone timeZone = new TimeZone();
        timeZone.name = string2;
        timeZone.fullName = string3;
        DataInputStream dataInputStream = TimeZone.openDb();
        try {
            dataInputStream.skip(indexOffsets[n]);
            int n3 = dataInputStream.readUnsignedShort();
            timeZone.rules = new Rule[n3];
            for (int i = 0; i < n3; ++i) {
                Rule rule = timeZone.rules[i] = new Rule();
                rule.startYear = dataInputStream.readUnsignedShort();
                rule.offset = dataInputStream.readInt();
                rule.stdAbbr = dataInputStream.readUTF();
                rule.dstOffset = dataInputStream.readInt();
                if (rule.dstOffset == 0) continue;
                rule.dstAbbr = dataInputStream.readUTF();
                rule.dstStart = TimeZone.loadDstTime(dataInputStream);
                rule.dstEnd = TimeZone.loadDstTime(dataInputStream);
                if (i == 0 || timeZone.rules[i - 1].startYear > rule.startYear) continue;
                throw new IOException("TimeZone rules not sorted: " + string2);
            }
        }
        finally {
            dataInputStream.close();
        }
        return timeZone;
    }

    static DstTime loadDstTime(DataInputStream dataInputStream) throws IOException {
        DstTime dstTime = new DstTime();
        dstTime.mon = dataInputStream.readByte();
        dstTime.onMode = dataInputStream.readByte();
        dstTime.onWeekday = dataInputStream.readByte();
        dstTime.onDay = dataInputStream.readByte();
        dstTime.atTime = dataInputStream.readInt();
        dstTime.atMode = dataInputStream.readByte();
        return dstTime;
    }

    static DataInputStream openDb() throws IOException {
        if (Sys.isJarDist) {
            return new DataInputStream(new BufferedInputStream(TimeZone.class.getClassLoader().getResourceAsStream("etc/sys/timezones.ftz")));
        }
        return new DataInputStream(new BufferedInputStream(new FileInputStream(dbFile)));
    }

    java.util.TimeZone java() {
        return java.util.TimeZone.getTimeZone(this.name);
    }

    static int dstOffset(Rule rule, int n, int n2, int n3, int n4) {
        DstTime dstTime = rule.dstStart;
        DstTime dstTime2 = rule.dstEnd;
        if (dstTime == null) {
            return 0;
        }
        int n5 = TimeZone.compare(rule, dstTime, n, n2, n3, n4);
        int n6 = TimeZone.compare(rule, dstTime2, n, n2, n3, n4);
        if (dstTime2.mon < dstTime.mon ? n6 > 0 || n5 <= 0 : n5 <= 0 && n6 > 0) {
            return rule.dstOffset;
        }
        return 0;
    }

    static int compare(Rule rule, DstTime dstTime, int n, int n2, int n3, int n4) {
        int n5 = TimeZone.compareMonth(dstTime, n2);
        if (n5 != 0) {
            return n5;
        }
        n5 = TimeZone.compareOnDay(rule, dstTime, n, n2, n3);
        if (n5 != 0) {
            return n5;
        }
        return TimeZone.compareAtTime(rule, dstTime, n4);
    }

    static int compareMonth(DstTime dstTime, int n) {
        if (dstTime.mon < n) {
            return -1;
        }
        if (dstTime.mon > n) {
            return 1;
        }
        return 0;
    }

    static int compareOnDay(Rule rule, DstTime dstTime, int n, int n2, int n3) {
        if (dstTime.atMode == 117 && rule.offset + dstTime.atTime < 0) {
            ++n3;
        }
        switch (dstTime.onMode) {
            case 100: {
                if (dstTime.onDay < n3) {
                    return -1;
                }
                if (dstTime.onDay > n3) {
                    return 1;
                }
                return 0;
            }
            case 108: {
                int n4 = DateTime.weekdayInMonth(n, n2, dstTime.onWeekday, -1);
                if (n4 < n3) {
                    return -1;
                }
                if (n4 > n3) {
                    return 1;
                }
                return 0;
            }
            case 62: {
                int n5;
                for (n5 = DateTime.weekdayInMonth(n, n2, dstTime.onWeekday, 1); n5 < dstTime.onDay; n5 += 7) {
                }
                if (n5 < n3) {
                    return -1;
                }
                if (n5 > n3) {
                    return 1;
                }
                return 0;
            }
        }
        throw new IllegalStateException("" + (char)dstTime.onMode);
    }

    static int compareAtTime(Rule rule, DstTime dstTime, int n) {
        int n2 = dstTime.atTime;
        if (dstTime.atMode == 117) {
            n2 = rule.offset + dstTime.atTime < 0 ? 86400 + rule.offset + dstTime.atTime : (n2 += rule.offset);
        }
        if (n2 < n) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    private static TimeZone loadFallback(String string, String string2) {
        TimeZone timeZone = new TimeZone();
        timeZone.name = string2;
        timeZone.fullName = string;
        timeZone.rules = new Rule[]{new Rule()};
        return timeZone;
    }

    public static TimeZone fromJava(String string) {
        if (string.equals("GMT0")) {
            return utc;
        }
        if (string.equals("GMT+00:00")) {
            return utc;
        }
        if (string.equals("GMT-00:00")) {
            return utc;
        }
        if (string.startsWith("GMT")) {
            if (string.endsWith(":00")) {
                string = string.substring(0, string.length() - 3);
            }
            if (string.startsWith("GMT-0")) {
                string = "GMT-" + string.substring(5);
            }
            if (string.startsWith("GMT+0")) {
                string = "GMT+" + string.substring(5);
            }
            return TimeZone.fromStr(string);
        }
        if (string.equals("US/Eastern")) {
            return TimeZone.fromStr("New_York");
        }
        if (string.equals("US/Central")) {
            return TimeZone.fromStr("Chicago");
        }
        if (string.equals("US/Mountain")) {
            return TimeZone.fromStr("Denver");
        }
        if (string.equals("US/Pacific")) {
            return TimeZone.fromStr("Los_Angeles");
        }
        if (string.equals("US/Arizona")) {
            return TimeZone.fromStr("Phoenix");
        }
        return TimeZone.fromStr(string);
    }

    static {
        cache = new HashMap();
        try {
            TimeZone.loadIndex();
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: Cannot load timezone database");
            throwable.printStackTrace();
        }
        try {
            utc = TimeZone.fromStr("Etc/UTC");
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: Cannot init UTC timezone");
            throwable.printStackTrace();
            utc = TimeZone.loadFallback("Etc/UTC", "UTC");
        }
        try {
            rel = TimeZone.fromStr("Etc/Rel");
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: Cannot init Rel timezone");
            throwable.printStackTrace();
            rel = TimeZone.loadFallback("Etc/Rel", "Rel");
        }
        try {
            String string = Sys.sysConfig("timezone");
            cur = string != null ? TimeZone.fromStr(string) : TimeZone.fromJava(java.util.TimeZone.getDefault().getID());
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: Cannot init current timezone");
            throwable.printStackTrace();
            cur = utc;
        }
    }

    static class DstTime {
        byte mon;
        byte onMode;
        byte onWeekday;
        byte onDay;
        int atTime;
        byte atMode;

        DstTime() {
        }
    }

    static class Rule {
        int startYear;
        int offset;
        String stdAbbr;
        int dstOffset;
        String dstAbbr;
        DstTime dstStart;
        DstTime dstEnd;

        Rule() {
        }

        boolean isWallTime() {
            return this.dstStart.atMode == 119;
        }
    }
}

