/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Err;
import fan.sys.FanInt;
import fan.sys.FanObj;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.Type;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class Uuid
extends FanObj {
    static final Factory factory = new Factory();
    private final long hi;
    private final long lo;

    public static Uuid fromStr(String string) {
        return Uuid.fromStr(string, true);
    }

    public static Uuid fromStr(String string, boolean bl) {
        try {
            if (string.length() != 36 || string.charAt(8) != '-' || string.charAt(13) != '-' || string.charAt(18) != '-' || string.charAt(23) != '-') {
                throw new Exception();
            }
            long l = Long.parseLong(string.substring(0, 8), 16);
            long l2 = Long.parseLong(string.substring(9, 13), 16);
            long l3 = Long.parseLong(string.substring(14, 18), 16);
            long l4 = Long.parseLong(string.substring(19, 23), 16);
            long l5 = Long.parseLong(string.substring(24), 16);
            return new Uuid(l << 32 | l2 << 16 | l3, l4 << 48 | l5);
        }
        catch (Throwable throwable) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Uuid", string);
        }
    }

    public static Uuid make() {
        try {
            return factory.make();
        }
        catch (Throwable throwable) {
            throw Err.make(throwable);
        }
    }

    public static Uuid makeBits(long l, long l2) {
        return new Uuid(l, l2);
    }

    private Uuid(long l, long l2) {
        this.hi = l;
        this.lo = l2;
    }

    public long bitsHi() {
        return this.hi;
    }

    public long bitsLo() {
        return this.lo;
    }

    public boolean equals(Object object) {
        if (object instanceof Uuid) {
            Uuid uuid = (Uuid)object;
            return this.hi == uuid.hi && this.lo == uuid.lo;
        }
        return false;
    }

    public int hashCode() {
        long l = this.hash();
        return (int)(l ^ l >>> 32);
    }

    public long hash() {
        return this.hi ^ this.lo;
    }

    public long compare(Object object) {
        Uuid uuid = (Uuid)object;
        if (this.hi != uuid.hi) {
            return this.hi < uuid.hi ? -1L : 1L;
        }
        if (this.lo == uuid.lo) {
            return 0L;
        }
        return this.lo < uuid.lo ? -1L : 1L;
    }

    public Type typeof() {
        return Sys.UuidType;
    }

    public String toStr() {
        StringBuilder stringBuilder = new StringBuilder(36);
        Uuid.append(stringBuilder, this.hi >> 32 & 0xFFFFFFFFL, 8);
        stringBuilder.append('-');
        Uuid.append(stringBuilder, this.hi >> 16 & 0xFFFFL, 4);
        stringBuilder.append('-');
        Uuid.append(stringBuilder, this.hi & 0xFFFFL, 4);
        stringBuilder.append('-');
        Uuid.append(stringBuilder, this.lo >> 48 & 0xFFFFL, 4);
        stringBuilder.append('-');
        Uuid.append(stringBuilder, this.lo & 0xFFFFFFFFFFFFL, 12);
        return stringBuilder.toString();
    }

    private static void append(StringBuilder stringBuilder, long l, int n) {
        String string = Long.toHexString(l);
        for (int i = string.length(); i < n; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
    }

    static class Factory {
        long lastMillis;
        int millisCounter;
        long seq;
        long nodeAddr = this.resolveNodeAddr();

        Factory() {
            this.seq = FanInt.random.nextLong();
        }

        synchronized Uuid make() throws Exception {
            return new Uuid(this.makeHi(), this.makeLo());
        }

        private long makeHi() {
            long l = System.currentTimeMillis() - 946684800000L;
            if (this.lastMillis != l) {
                this.millisCounter = 0;
                this.lastMillis = l;
            }
            return l * 1000000L + (long)this.millisCounter++;
        }

        private long makeLo() {
            return (this.seq++ & 0xFFFFL) << 48 | this.nodeAddr;
        }

        private long resolveNodeAddr() {
            try {
                return this.resolveMacAddr();
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                return this.resolveIpAddr();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return FanInt.random.nextLong();
            }
        }

        private long resolveMacAddr() throws Exception {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                byte[] byArray = networkInterface.getHardwareAddress();
                if (byArray == null) continue;
                return this.toLong(byArray);
            }
            throw new NoSuchElementException();
        }

        private long resolveIpAddr() throws Exception {
            return this.toLong(InetAddress.getLocalHost().getAddress());
        }

        private long toLong(byte[] byArray) {
            if (byArray.length < 6) {
                byte[] byArray2 = new byte[6];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                for (int i = byArray.length; i < byArray2.length; ++i) {
                    byArray2[i] = (byte)FanInt.random.nextInt();
                }
                byArray = byArray2;
            }
            long l = ((long)byArray[0] & 0xFFL) << 40 | ((long)byArray[1] & 0xFFL) << 32 | ((long)byArray[2] & 0xFFL) << 24 | ((long)byArray[3] & 0xFFL) << 16 | ((long)byArray[4] & 0xFFL) << 8 | ((long)byArray[5] & 0xFFL) << 0;
            for (int i = 6; i < byArray.length; ++i) {
                l ^= ((long)byArray[i] & 0xFFL) << (i - 6) % 6 * 8;
            }
            return l;
        }
    }
}

