/*
 * Decompiled with CFR 0.152.
 */
package fanx.emit;

import fanx.emit.AttrEmit;
import fanx.emit.EmitConst;
import fanx.emit.FieldEmit;
import fanx.emit.MethodEmit;
import fanx.util.Box;
import java.util.ArrayList;
import java.util.HashMap;

public class Emitter
implements EmitConst {
    public String className;
    public String superClassName;
    int thisClassIndex;
    int superClassIndex;
    int[] interfaces;
    int flags;
    ArrayList fields = new ArrayList();
    ArrayList methods = new ArrayList();
    ArrayList attrs = new ArrayList();
    ArrayList cp = new ArrayList();
    HashMap cpUtf = new HashMap();
    HashMap cpClass = new HashMap();
    HashMap cpString = new HashMap();
    HashMap cpInteger = new HashMap();
    HashMap cpLong = new HashMap();
    HashMap cpFloat = new HashMap();
    HashMap cpDouble = new HashMap();
    HashMap cpNt = new HashMap();
    HashMap cpMethod = new HashMap();
    HashMap cpField = new HashMap();
    HashMap cpInterface = new HashMap();

    public Emitter(String string, String string2, String[] stringArray, int n) {
        this.init(string, string2, stringArray, n);
    }

    public Emitter() {
    }

    public void init(String string, String string2, String[] stringArray, int n) {
        this.className = string;
        this.superClassName = string2;
        this.cp.add(new CpDummy());
        this.thisClassIndex = this.cls(string);
        this.superClassIndex = this.cls(string2);
        this.interfaces = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.interfaces[i] = this.cls(stringArray[i]);
        }
        this.flags = n;
    }

    public FieldEmit emitField(String string, String string2, int n) {
        String string3 = this.className + "." + string + ":" + string2;
        FieldEmit fieldEmit = new FieldEmit(this, string3, this.utf(string), this.utf(string2), n);
        this.fields.add(fieldEmit);
        return fieldEmit;
    }

    public MethodEmit emitMethod(String string, String string2, int n) {
        String string3 = this.className + "." + string + string2;
        MethodEmit methodEmit = new MethodEmit(this, string3, this.utf(string), this.utf(string2), n);
        this.methods.add(methodEmit);
        return methodEmit;
    }

    public AttrEmit emitAttr(String string) {
        AttrEmit attrEmit = new AttrEmit(this, this.utf(string));
        this.attrs.add(attrEmit);
        return attrEmit;
    }

    public Box pack() {
        int n;
        Box box = new Box();
        box.u4(-889275714);
        box.u2(0);
        box.u2(49);
        box.u2(this.cp.size());
        for (n = 1; n < this.cp.size(); ++n) {
            ((CpInfo)this.cp.get(n)).pack(box);
        }
        box.u2(this.flags);
        box.u2(this.thisClassIndex);
        box.u2(this.superClassIndex);
        box.u2(this.interfaces.length);
        for (n = 0; n < this.interfaces.length; ++n) {
            box.u2(this.interfaces[n]);
        }
        box.u2(this.fields.size());
        for (n = 0; n < this.fields.size(); ++n) {
            ((FieldEmit)this.fields.get(n)).pack(box);
        }
        box.u2(this.methods.size());
        for (n = 0; n < this.methods.size(); ++n) {
            ((MethodEmit)this.methods.get(n)).pack(box);
        }
        box.u2(this.attrs.size());
        for (n = 0; n < this.attrs.size(); ++n) {
            ((AttrEmit)this.attrs.get(n)).pack(box);
        }
        return box;
    }

    public int utf(String string) {
        CpUtf cpUtf = (CpUtf)this.cpUtf.get(string);
        if (cpUtf == null) {
            cpUtf = new CpUtf(string);
            this.cpUtf.put(string, cpUtf);
            this.add(cpUtf);
        }
        return cpUtf.index;
    }

    public int strConst(String string) {
        CpString cpString = (CpString)this.cpString.get(string);
        if (cpString == null) {
            cpString = new CpString(this.utf(string));
            this.cpString.put(string, cpString);
            this.add(cpString);
        }
        return cpString.index;
    }

    public int intConst(Integer n) {
        CpInteger cpInteger = (CpInteger)this.cpInteger.get(n);
        if (cpInteger == null) {
            cpInteger = new CpInteger(n);
            this.cpInteger.put(n, cpInteger);
            this.add(cpInteger);
        }
        return cpInteger.index;
    }

    public int longConst(Long l) {
        CpLong cpLong = (CpLong)this.cpLong.get(l);
        if (cpLong == null) {
            cpLong = new CpLong(l);
            this.cpLong.put(l, cpLong);
            this.add(cpLong);
            this.add(new CpDummy());
        }
        return cpLong.index;
    }

    public int floatConst(Float f) {
        CpFloat cpFloat = (CpFloat)this.cpFloat.get(f);
        if (cpFloat == null) {
            cpFloat = new CpFloat(f.floatValue());
            this.cpFloat.put(f, cpFloat);
            this.add(cpFloat);
        }
        return cpFloat.index;
    }

    public int doubleConst(Double d) {
        CpDouble cpDouble = (CpDouble)this.cpDouble.get(d);
        if (cpDouble == null) {
            cpDouble = new CpDouble(d);
            this.cpDouble.put(d, cpDouble);
            this.add(cpDouble);
            this.add(new CpDummy());
        }
        return cpDouble.index;
    }

    public int cls(String string) {
        CpClass cpClass = (CpClass)this.cpClass.get(string);
        if (cpClass == null) {
            cpClass = new CpClass(this.utf(string));
            this.cpClass.put(string, cpClass);
            this.add(cpClass);
        }
        return cpClass.index;
    }

    public int nt(int n, int n2) {
        Integer n3 = new Integer(n << 16 | n2);
        CpNameType cpNameType = (CpNameType)this.cpNt.get(n3);
        if (cpNameType == null) {
            cpNameType = new CpNameType(n, n2);
            this.cpNt.put(n3, cpNameType);
            this.add(cpNameType);
        }
        return cpNameType.index;
    }

    public int field(String string) {
        CpField cpField = (CpField)this.cpField.get(string);
        if (cpField == null) {
            int n = string.indexOf(58);
            int n2 = string.lastIndexOf(46, n - 1);
            int n3 = this.cls(string.substring(0, n2));
            int n4 = this.utf(string.substring(n2 + 1, n));
            int n5 = this.utf(string.substring(n + 1));
            int n6 = this.nt(n4, n5);
            cpField = new CpField(n3, n6);
            this.cpField.put(string, cpField);
            this.add(cpField);
        }
        return cpField.index;
    }

    public int method(String string) {
        CpMethod cpMethod = (CpMethod)this.cpMethod.get(string);
        if (cpMethod == null) {
            int n = string.indexOf(40);
            int n2 = string.lastIndexOf(46, n - 1);
            int n3 = this.cls(string.substring(0, n2));
            int n4 = this.utf(string.substring(n2 + 1, n));
            int n5 = this.utf(string.substring(n));
            int n6 = this.nt(n4, n5);
            cpMethod = new CpMethod(n3, n6);
            this.cpMethod.put(string, cpMethod);
            this.add(cpMethod);
        }
        return cpMethod.index;
    }

    public int interfaceRef(String string) {
        CpInterface cpInterface = (CpInterface)this.cpInterface.get(string);
        if (cpInterface == null) {
            int n = string.indexOf(40);
            int n2 = string.lastIndexOf(46, n - 1);
            int n3 = this.cls(string.substring(0, n2));
            int n4 = this.utf(string.substring(n2 + 1, n));
            int n5 = this.utf(string.substring(n));
            int n6 = this.nt(n4, n5);
            cpInterface = new CpInterface(n3, n6);
            this.cpInterface.put(string, cpInterface);
            this.add(cpInterface);
        }
        return cpInterface.index;
    }

    private void add(CpInfo cpInfo) {
        cpInfo.index = this.cp.size();
        this.cp.add(cpInfo);
    }

    private void cpDump() {
        for (int i = 1; i < this.cp.size(); ++i) {
            CpInfo cpInfo = (CpInfo)this.cp.get(i);
            if (cpInfo.index != i) {
                throw new IllegalStateException();
            }
            String string = "" + i;
            if (string.length() == 1) {
                string = "0" + string;
            }
            System.out.println("[" + string + "] " + this.toStr(cpInfo));
        }
    }

    String utfToStr(int n) {
        return ((CpUtf)this.cp.get((int)n)).val;
    }

    String clsToStr(int n) {
        return this.utfToStr(((CpClass)this.cp.get((int)n)).name);
    }

    String ntToStr(int n) {
        return this.utfToStr(((CpNameType)this.cp.get((int)n)).name) + " " + this.utfToStr(((CpNameType)this.cp.get((int)n)).type);
    }

    String toStr(CpInfo cpInfo) {
        if (cpInfo instanceof CpUtf) {
            return "Utf  " + ((CpUtf)cpInfo).val;
        }
        if (cpInfo instanceof CpInteger) {
            return "Int  " + ((CpInteger)cpInfo).val;
        }
        if (cpInfo instanceof CpLong) {
            return "Long " + ((CpLong)cpInfo).val;
        }
        if (cpInfo instanceof CpFloat) {
            return "F    " + ((CpFloat)cpInfo).val;
        }
        if (cpInfo instanceof CpDouble) {
            return "D    " + ((CpDouble)cpInfo).val;
        }
        if (cpInfo instanceof CpDummy) {
            return "Dummy";
        }
        if (cpInfo instanceof CpString) {
            CpString cpString = (CpString)cpInfo;
            return "String  " + cpString.utf + "=" + this.utfToStr(cpString.utf);
        }
        if (cpInfo instanceof CpClass) {
            CpClass cpClass = (CpClass)cpInfo;
            return "Cls  " + cpClass.name + "=" + this.utfToStr(cpClass.name);
        }
        if (cpInfo instanceof CpNameType) {
            CpNameType cpNameType = (CpNameType)cpInfo;
            return "NT   " + cpNameType.name + "=" + this.utfToStr(cpNameType.name) + "  " + cpNameType.type + "=" + this.utfToStr(cpNameType.type);
        }
        if (cpInfo instanceof CpMethod) {
            CpMethod cpMethod = (CpMethod)cpInfo;
            return "M    " + cpMethod.cls + "=" + this.clsToStr(cpMethod.cls) + "  " + cpMethod.nt + "=" + this.ntToStr(cpMethod.nt);
        }
        if (cpInfo instanceof CpField) {
            CpField cpField = (CpField)cpInfo;
            return "F    " + cpField.cls + "=" + this.clsToStr(cpField.cls) + "  " + cpField.nt + "=" + this.ntToStr(cpField.nt);
        }
        return cpInfo.toString();
    }

    static class CpDummy
    extends CpInfo {
        CpDummy() {
        }

        void pack(Box box) {
        }
    }

    static class CpInterface
    extends CpInfo {
        int cls;
        int nt;

        CpInterface(int n, int n2) {
            this.cls = n;
            this.nt = n2;
        }

        void pack(Box box) {
            box.u1(11);
            box.u2(this.cls);
            box.u2(this.nt);
        }
    }

    static class CpMethod
    extends CpInfo {
        int cls;
        int nt;

        CpMethod(int n, int n2) {
            this.cls = n;
            this.nt = n2;
        }

        void pack(Box box) {
            box.u1(10);
            box.u2(this.cls);
            box.u2(this.nt);
        }
    }

    static class CpField
    extends CpInfo {
        int cls;
        int nt;

        CpField(int n, int n2) {
            this.cls = n;
            this.nt = n2;
        }

        void pack(Box box) {
            box.u1(9);
            box.u2(this.cls);
            box.u2(this.nt);
        }
    }

    static class CpNameType
    extends CpInfo {
        int name;
        int type;

        CpNameType(int n, int n2) {
            this.name = n;
            this.type = n2;
        }

        void pack(Box box) {
            box.u1(12);
            box.u2(this.name);
            box.u2(this.type);
        }
    }

    static class CpClass
    extends CpInfo {
        int name;

        CpClass(int n) {
            this.name = n;
        }

        void pack(Box box) {
            box.u1(7);
            box.u2(this.name);
        }
    }

    static class CpDouble
    extends CpInfo {
        double val;

        CpDouble(double d) {
            this.val = d;
        }

        void pack(Box box) {
            box.u1(6);
            box.f8(this.val);
        }
    }

    static class CpFloat
    extends CpInfo {
        float val;

        CpFloat(float f) {
            this.val = f;
        }

        void pack(Box box) {
            box.u1(4);
            box.f4(this.val);
        }
    }

    static class CpLong
    extends CpInfo {
        long val;

        CpLong(long l) {
            this.val = l;
        }

        void pack(Box box) {
            box.u1(5);
            box.u8(this.val);
        }
    }

    static class CpInteger
    extends CpInfo {
        int val;

        CpInteger(int n) {
            this.val = n;
        }

        void pack(Box box) {
            box.u1(3);
            box.u4(this.val);
        }
    }

    static class CpString
    extends CpInfo {
        int utf;

        CpString(int n) {
            this.utf = n;
        }

        void pack(Box box) {
            box.u1(8);
            box.u2(this.utf);
        }
    }

    static class CpUtf
    extends CpInfo {
        String val;

        CpUtf(String string) {
            this.val = string;
        }

        void pack(Box box) {
            box.u1(1);
            box.utf(this.val);
        }
    }

    static abstract class CpInfo {
        int index;

        CpInfo() {
        }

        abstract void pack(Box var1);
    }
}

