/*
 * Decompiled with CFR 0.152.
 */
package fanx.emit;

import fan.sys.List;
import fan.sys.Method;
import fan.sys.Param;
import fanx.emit.CodeEmit;
import fanx.emit.EmitConst;
import fanx.emit.FCodeEmit;
import fanx.emit.FTypeEmit;
import fanx.emit.MethodEmit;
import fanx.fcode.FBuf;
import fanx.fcode.FMethod;
import fanx.fcode.FTypeRef;
import fanx.util.FanUtil;

public class FMethodEmit
implements EmitConst {
    FTypeEmit emit;
    FMethod method;
    FBuf code;
    String name;
    int jflags;
    boolean isStatic;
    boolean isCtor;
    boolean isNative;
    FTypeRef ret;
    boolean self;
    String selfName;
    int paramLen;
    String sig;
    MethodEmit me;
    int lineNum;

    public FMethodEmit(FTypeEmit fTypeEmit, FMethod fMethod) {
        this.emit = fTypeEmit;
        this.method = fMethod;
        this.code = fMethod.code;
        this.name = fMethod.name;
        this.jflags = FTypeEmit.jflags(fMethod.flags);
        this.paramLen = fMethod.paramCount;
        this.isStatic = (fMethod.flags & 0x8000) != 0;
        this.isCtor = (fMethod.flags & 4) != 0;
        this.isNative = (fMethod.flags & 0x200) != 0;
        this.ret = fTypeEmit.pod.typeRef(fMethod.inheritedRet);
        this.selfName = fTypeEmit.selfName;
        this.lineNum = fMethod.attrs.lineNum;
    }

    public FMethodEmit(FTypeEmit fTypeEmit) {
        this.emit = fTypeEmit;
    }

    public MethodEmit emitStandard() {
        MethodEmit methodEmit = this.doEmit();
        this.emitWrappers(methodEmit);
        return methodEmit;
    }

    public MethodEmit emitCtor() {
        String string = this.name;
        this.jflags |= 8;
        this.isStatic = true;
        this.name = string + "$";
        this.self = true;
        MethodEmit methodEmit = this.doEmit();
        MethodEmit[] methodEmitArray = this.emitWrappers(methodEmit);
        this.name = string;
        this.self = false;
        this.ret = this.emit.pod.typeRef(this.emit.type.self);
        this.code = null;
        int n = this.emit.method(this.selfName + ".<init>()V");
        MethodEmit methodEmit2 = this.emitCtorFactory(n, methodEmit, this.method.paramCount);
        for (int i = 0; i < this.method.paramCount; ++i) {
            if (this.method.vars[i].def == null) continue;
            this.emitCtorFactory(n, methodEmitArray[i], i);
        }
        return methodEmit2;
    }

    private MethodEmit emitCtorFactory(int n, MethodEmit methodEmit, int n2) {
        this.paramLen = n2;
        MethodEmit methodEmit2 = this.doEmit();
        CodeEmit codeEmit = methodEmit2.emitCode();
        codeEmit.op2(187, this.emit.cls(this.selfName));
        codeEmit.op(89);
        codeEmit.op2(183, n);
        codeEmit.op(89);
        codeEmit.maxLocals = this.pushArgs(codeEmit, false, n2);
        codeEmit.maxStack = codeEmit.maxLocals + 2;
        codeEmit.op2(184, methodEmit.ref());
        codeEmit.op(176);
        codeEmit.emitLineNumber(this.lineNum);
        return methodEmit2;
    }

    public MethodEmit emitCtorWithJavaSuper() {
        String string = this.name;
        this.name = "<init>";
        MethodEmit methodEmit = this.doEmit();
        this.emitWrappers(methodEmit);
        this.name = string;
        this.self = false;
        this.ret = this.emit.pod.typeRef(this.emit.type.self);
        this.code = null;
        this.jflags |= 8;
        this.isStatic = true;
        MethodEmit methodEmit2 = this.doEmit();
        CodeEmit codeEmit = methodEmit2.emitCode();
        codeEmit.op2(187, this.emit.cls(this.selfName));
        codeEmit.op(89);
        codeEmit.maxLocals = this.pushArgs(codeEmit, false, this.method.paramCount) + 1;
        codeEmit.maxStack = codeEmit.maxLocals + 2;
        codeEmit.op2(183, methodEmit.ref());
        codeEmit.op(176);
        codeEmit.emitLineNumber(this.lineNum);
        this.emitWrappers(methodEmit2);
        return methodEmit2;
    }

    public MethodEmit emitNative() {
        this.code = null;
        MethodEmit methodEmit = this.doEmit();
        CodeEmit codeEmit = methodEmit.emitCode();
        if (this.isStatic) {
            int n = this.emit.method(this.selfName + "Peer." + this.name + this.sig);
            codeEmit.maxLocals = this.pushArgs(codeEmit, false, this.paramLen);
            codeEmit.maxStack = Math.max(codeEmit.maxLocals, 2);
            codeEmit.op2(184, n);
        } else {
            this.self = true;
            String string = this.signature();
            this.self = false;
            int n = this.emit.method(this.selfName + "Peer." + this.name + string);
            codeEmit.op(42);
            codeEmit.op2(180, this.emit.peerField.ref());
            codeEmit.maxLocals = this.pushArgs(codeEmit, true, this.paramLen) + 1;
            codeEmit.maxStack = Math.max(codeEmit.maxLocals, 2);
            codeEmit.op2(182, n);
        }
        codeEmit.op(FCodeEmit.returnOp(this.ret));
        this.emitWrappers(methodEmit);
        return methodEmit;
    }

    public void emitMixinInterface() {
        if (this.isStatic || this.isCtor) {
            return;
        }
        this.jflags |= 0x401;
        this.code = null;
        this.doEmit();
        for (int i = 0; i < this.method.paramCount; ++i) {
            if (this.method.vars[i].def == null) continue;
            this.paramLen = i;
            this.doEmit();
        }
    }

    public void emitMixinBody() {
        if (this.method.code == null) {
            return;
        }
        if (!this.isStatic) {
            this.self = true;
        }
        this.jflags |= 9;
        MethodEmit methodEmit = this.doEmit();
        this.emitWrappers(methodEmit);
    }

    public void emitMixinRouter(Method method) {
        int n;
        int n2;
        String string = "fan/" + method.parent().pod().name() + "/" + method.parent().name();
        String string2 = method.name();
        int n3 = FTypeEmit.jflags(method.flags()) | 1 | 0x1000;
        List list = method.params();
        int n4 = n2 = list.sz();
        for (n = 0; n < n2; ++n) {
            if (!((Param)list.get(n)).hasDefault()) continue;
            n4 = n;
            break;
        }
        for (n = n4; n <= n2; ++n) {
            String string3 = this.signature(method, null, n);
            String string4 = this.signature(method, string, n);
            MethodEmit methodEmit = this.emit.emitMethod(string2, string3, n3);
            CodeEmit codeEmit = methodEmit.emitCode();
            codeEmit.op(42);
            int n5 = 1;
            for (int i = 0; i < n; ++i) {
                Param param = (Param)method.params().get(i);
                n5 = FCodeEmit.loadVar(codeEmit, FanUtil.toJavaStackType(param.type()), n5);
            }
            codeEmit.op2(184, this.emit.method(string + "$." + string2 + string4));
            codeEmit.op(FCodeEmit.returnOp(FanUtil.toJavaStackType(method.returns())));
            codeEmit.maxLocals = n5;
            codeEmit.maxStack = n5 + 1;
            codeEmit.emitLineNumber(this.emit.lineNum);
        }
    }

    private MethodEmit[] emitWrappers(MethodEmit methodEmit) {
        int n = this.jflags;
        this.jflags &= 0xFFFFFBFF;
        MethodEmit[] methodEmitArray = null;
        for (int i = 0; i < this.method.paramCount; ++i) {
            if (this.method.vars[i].def == null) continue;
            if (methodEmitArray == null) {
                methodEmitArray = new MethodEmit[this.method.paramCount];
            }
            methodEmitArray[i] = this.emitWrapper(methodEmit, i);
        }
        this.paramLen = this.method.paramCount;
        this.jflags = n;
        return methodEmitArray;
    }

    private MethodEmit emitWrapper(MethodEmit methodEmit, int n) {
        this.paramLen = n;
        this.code = null;
        CodeEmit codeEmit = this.doEmit().emitCode();
        this.pushArgs(codeEmit, !this.isStatic || this.self, n);
        FCodeEmit.Reg[] regArray = FCodeEmit.initRegs(this.emit, this.isStatic & !this.isCtor, this.method.vars);
        for (int i = n; i < this.method.paramCount; ++i) {
            FCodeEmit fCodeEmit = new FCodeEmit(this.emit, this.method.vars[i].def, codeEmit, regArray, this.emit.pod.typeRef(this.method.ret));
            fCodeEmit.emit();
        }
        codeEmit.maxStack = codeEmit.maxLocals + 4;
        codeEmit.op2((methodEmit.flags & 8) != 0 ? 184 : 182, methodEmit.ref());
        codeEmit.op(FCodeEmit.returnOp(this.ret));
        return this.me;
    }

    protected MethodEmit doEmit() {
        this.sig = this.signature();
        this.me = this.emit.emitMethod(this.name, this.sig, this.jflags);
        if (this.code != null) {
            new FCodeEmit(this.emit, this.method, this.me.emitCode()).emit();
        }
        return this.me;
    }

    private String signature() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        if (this.self) {
            stringBuilder.append('L').append(this.selfName).append(';');
        }
        for (int i = 0; i < this.paramLen; ++i) {
            this.emit.pod.typeRef(this.method.vars[i].type).jsig(stringBuilder);
        }
        stringBuilder.append(')');
        this.ret.jsig(stringBuilder);
        return stringBuilder.toString();
    }

    private String signature(Method method, String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        if (string != null) {
            stringBuilder.append('L').append(string).append(';');
        }
        for (int i = 0; i < n; ++i) {
            Param param = (Param)method.params().get(i);
            stringBuilder.append(FanUtil.toJavaMemberSig(param.type()));
        }
        stringBuilder.append(')');
        stringBuilder.append(FanUtil.toJavaMemberSig(method.inheritedReturns()));
        return stringBuilder.toString();
    }

    private int pushArgs(CodeEmit codeEmit, boolean bl, int n) {
        int n2 = 0;
        if (bl) {
            codeEmit.op(42);
            ++n2;
        }
        for (int i = 0; i < n; ++i) {
            FTypeRef fTypeRef = this.emit.pod.typeRef(this.method.vars[i].type);
            n2 = FCodeEmit.loadVar(codeEmit, fTypeRef.stackType, n2);
        }
        return n2;
    }
}

