/*
 * Decompiled with CFR 0.152.
 */
package fanx.fcode;

import fanx.fcode.FBuf;
import fanx.fcode.FConst;
import fanx.fcode.FStore;
import java.io.IOException;

public class FAttrs
implements FConst {
    static final FAttrs none = new FAttrs();
    public FBuf errTable;
    public FFacet[] facets;
    public int lineNum;
    public FBuf lineNums;
    public String sourceFile;

    /*
     * Enabled aggressive block sorting
     */
    public static FAttrs read(FStore.Input input) throws IOException {
        int n = input.u2();
        if (n == 0) {
            return none;
        }
        FAttrs fAttrs = new FAttrs();
        int n2 = 0;
        while (true) {
            block12: {
                if (n2 >= n) {
                    return fAttrs;
                }
                String string = input.name();
                switch (string.charAt(0)) {
                    case 'E': {
                        if (!string.equals("ErrTable")) break;
                        fAttrs.errTable(input);
                        break block12;
                    }
                    case 'F': {
                        if (!string.equals("Facets")) break;
                        fAttrs.facets(input);
                        break block12;
                    }
                    case 'L': {
                        if (string.equals("LineNumber")) {
                            fAttrs.lineNumber(input);
                            break block12;
                        } else {
                            if (!string.equals("LineNumbers")) break;
                            fAttrs.lineNumbers(input);
                        }
                        break block12;
                    }
                    case 'S': {
                        if (!string.equals("SourceFile")) break;
                        fAttrs.sourceFile(input);
                        break block12;
                    }
                }
                int n3 = input.u2();
                if (input.skip(n3) != (long)n3) {
                    throw new IOException("Can't skip over attr " + string);
                }
            }
            ++n2;
        }
    }

    private void errTable(FStore.Input input) throws IOException {
        this.errTable = FBuf.read(input);
    }

    private void facets(FStore.Input input) throws IOException {
        input.u2();
        int n = input.u2();
        this.facets = new FFacet[n];
        for (int i = 0; i < n; ++i) {
            FFacet fFacet = this.facets[i] = new FFacet();
            fFacet.type = input.u2();
            fFacet.val = input.utf();
        }
    }

    private void lineNumber(FStore.Input input) throws IOException {
        input.u2();
        this.lineNum = input.u2();
    }

    private void lineNumbers(FStore.Input input) throws IOException {
        this.lineNums = FBuf.read(input);
    }

    private void sourceFile(FStore.Input input) throws IOException {
        input.u2();
        this.sourceFile = input.utf();
    }

    public static class FFacet {
        public int type;
        public String val;
    }
}

