/*
 * Decompiled with CFR 0.152.
 */
package fanx.fcode;

import fan.sys.ClassType;
import fan.sys.Slot;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FDoc {
    private BufferedReader in;
    private ClassType type;
    private String cur;

    public FDoc(InputStream inputStream, ClassType classType) throws IOException {
        this.in = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        this.type = classType;
    }

    public void read() throws IOException {
        this.consume();
        if (!this.cur.startsWith("== ")) {
            throw new IOException("Unexpected type line: " + this.cur);
        }
        this.type.doc = this.readAttrsToDoc();
        while (this.cur != null) {
            if (!this.cur.startsWith("-- ")) {
                throw new IOException("Unexpected slot line: " + this.cur);
            }
            String string = this.cur.endsWith("(") ? this.cur.substring(3, this.cur.length() - 1) : this.cur.substring(3, this.cur.indexOf(32, 4));
            String string2 = this.readAttrsToDoc();
            Slot slot = this.type.slot(string, false);
            if (slot == null) continue;
            slot.doc = string2;
        }
    }

    private String readAttrsToDoc() throws IOException {
        while (this.cur != null && this.cur.length() > 0) {
            this.consume();
        }
        this.consume();
        StringBuilder stringBuilder = new StringBuilder();
        while (this.cur != null && !this.cur.startsWith("-- ")) {
            stringBuilder.append(this.cur).append('\n');
            this.consume();
        }
        if (stringBuilder.length() == 0) {
            return "";
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '\n') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    private void consume() throws IOException {
        this.cur = this.in.readLine();
    }
}

