/*
 * Decompiled with CFR 0.152.
 */
package fanx.fcode;

import fan.sys.Duration;
import fan.sys.FanDecimal;
import fan.sys.Uri;
import fanx.fcode.FFieldRef;
import fanx.fcode.FMethodRef;
import fanx.fcode.FPod;
import fanx.fcode.FStore;
import fanx.fcode.FTypeRef;
import fanx.util.StrUtil;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class FTable {
    FPod pod;
    int size;
    Object[] table;

    protected FTable(FPod fPod) {
        this.pod = fPod;
    }

    public final int size() {
        return this.size;
    }

    public final Object get(int n) {
        return this.table[n];
    }

    public void dump(FPod fPod, PrintWriter printWriter) {
        for (int i = 0; i < this.size; ++i) {
            printWriter.print(StrUtil.padr("  [" + i + "] ", 8));
            printWriter.println(this.toString(i));
        }
        printWriter.flush();
    }

    public String toString(int n) {
        return this.table[n].toString();
    }

    public abstract FTable read(FStore.Input var1) throws IOException;

    static class Uris
    extends FTable {
        Uris(FPod fPod) {
            super(fPod);
        }

        public FTable read(FStore.Input input) throws IOException {
            if (input == null) {
                this.size = 0;
                return this;
            }
            this.size = input.u2();
            this.table = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.table[i] = Uri.fromStr(input.utf());
            }
            return this;
        }
    }

    static class Durations
    extends FTable {
        Durations(FPod fPod) {
            super(fPod);
        }

        public FTable read(FStore.Input input) throws IOException {
            if (input == null) {
                this.size = 0;
                return this;
            }
            this.size = input.u2();
            this.table = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.table[i] = Duration.make(input.u8());
            }
            return this;
        }
    }

    static class Strs
    extends FTable {
        Strs(FPod fPod) {
            super(fPod);
        }

        public FTable read(FStore.Input input) throws IOException {
            if (input == null) {
                this.size = 0;
                return this;
            }
            this.size = input.u2();
            this.table = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.table[i] = input.utf().intern();
            }
            return this;
        }
    }

    static class Decimals
    extends FTable {
        Decimals(FPod fPod) {
            super(fPod);
        }

        public FTable read(FStore.Input input) throws IOException {
            if (input == null) {
                this.size = 0;
                return this;
            }
            this.size = input.u2();
            this.table = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.table[i] = FanDecimal.fromStr(input.readUTF(), true);
            }
            return this;
        }
    }

    static class Floats
    extends FTable {
        Floats(FPod fPod) {
            super(fPod);
        }

        public FTable read(FStore.Input input) throws IOException {
            if (input == null) {
                this.size = 0;
                return this;
            }
            this.size = input.u2();
            this.table = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.table[i] = input.f8();
            }
            return this;
        }
    }

    static class Ints
    extends FTable {
        Ints(FPod fPod) {
            super(fPod);
        }

        public FTable read(FStore.Input input) throws IOException {
            if (input == null) {
                this.size = 0;
                return this;
            }
            this.size = input.u2();
            this.table = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.table[i] = input.u8();
            }
            return this;
        }
    }

    static class MethodRefs
    extends FTable {
        MethodRefs(FPod fPod) {
            super(fPod);
        }

        public String toString(int n) {
            return ((FMethodRef)this.table[n]).toString();
        }

        public FTable read(FStore.Input input) throws IOException {
            if (input == null) {
                this.size = 0;
                return this;
            }
            this.size = input.u2();
            this.table = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.table[i] = FMethodRef.read(input);
            }
            return this;
        }
    }

    static class FieldRefs
    extends FTable {
        FieldRefs(FPod fPod) {
            super(fPod);
        }

        public String toString(int n) {
            return ((FFieldRef)this.table[n]).toString();
        }

        public FTable read(FStore.Input input) throws IOException {
            if (input == null) {
                this.size = 0;
                return this;
            }
            this.size = input.u2();
            this.table = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.table[i] = FFieldRef.read(input);
            }
            return this;
        }
    }

    static class TypeRefs
    extends FTable {
        TypeRefs(FPod fPod) {
            super(fPod);
        }

        public String toString(int n) {
            if (n == -1) {
                return "null";
            }
            return ((FTypeRef)this.table[n]).signature;
        }

        public FTable read(FStore.Input input) throws IOException {
            if (input == null) {
                this.size = 0;
                return this;
            }
            this.size = input.u2();
            this.table = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.table[i] = FTypeRef.read(i, input);
            }
            return this;
        }
    }

    static class Names
    extends FTable {
        Names(FPod fPod) {
            super(fPod);
        }

        public FTable read(FStore.Input input) throws IOException {
            if (input == null) {
                this.size = 0;
                return this;
            }
            this.size = input.u2();
            this.table = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.table[i] = input.utf().intern();
            }
            return this;
        }
    }
}

