/*
 * Decompiled with CFR 0.152.
 */
package fanx.tools;

import fan.sys.Env;
import fan.sys.Err;
import fan.sys.FanStr;
import fan.sys.List;
import fan.sys.LocalFile;
import fan.sys.Map;
import fan.sys.Method;
import fan.sys.Param;
import fan.sys.Pod;
import fan.sys.Sys;
import fan.sys.Type;
import fanx.util.FileUtil;
import java.io.File;

public class Fan {
    public int execute(String string, String[] stringArray) throws Exception {
        Sys.bootEnv.setArgs(stringArray);
        this.checkInstall();
        File file = new File(string);
        if (file.exists() && string.toLowerCase().endsWith(".fan") && !file.isDirectory()) {
            return this.executeFile(file, stringArray);
        }
        return this.executeType(string, stringArray);
    }

    private void checkInstall() {
        try {
            File file = new File(Sys.homeDir, "lib" + File.separator + "install");
            if (!file.exists()) {
                return;
            }
            File[] fileArray = file.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                String string = file2.getName();
                if (!string.endsWith(".pod")) continue;
                System.out.println("INSTALL POD: " + string);
                FileUtil.copy(file2, new File(Sys.podsDir, string));
                file2.delete();
            }
            FileUtil.delete(file);
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: checkInstall");
            throwable.printStackTrace();
        }
    }

    private int executeFile(File file, String[] stringArray) throws Exception {
        LocalFile localFile = (LocalFile)new LocalFile(file).normalize();
        Map map = new Map(Sys.StrType, Sys.ObjType);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-fcodeDump")) continue;
            map.add("fcodeDump", Boolean.TRUE);
        }
        Pod pod = null;
        try {
            pod = Env.cur().compileScript(localFile, map).pod();
        }
        catch (Err err) {
            System.out.println("ERROR: cannot compile script");
            if (!err.getClass().getName().startsWith("fan.compiler")) {
                err.trace();
            }
            return -1;
        }
        catch (Exception exception) {
            System.out.println("ERROR: cannot compile script");
            exception.printStackTrace();
            return -1;
        }
        List list = pod.types();
        Type type = null;
        Method method = null;
        for (int i = 0; i < list.sz() && (method = (type = (Type)list.get(i)).method("main", false)) == null; ++i) {
        }
        if (method == null) {
            System.out.println("ERROR: missing main method: " + ((Type)list.get(0)).name() + ".main()");
            return -1;
        }
        return Fan.callMain(type, method);
    }

    private int executeType(String string, String[] stringArray) throws Exception {
        if (string.indexOf("::") < 0) {
            string = string + "::Main.main";
        } else if (string.indexOf(46) < 0) {
            string = string + ".main";
        }
        try {
            int n = string.lastIndexOf(46);
            Type type = Type.find(string.substring(0, n), true);
            Method method = type.method(string.substring(n + 1), true);
            return Fan.callMain(type, method);
        }
        catch (Throwable throwable) {
            System.out.println("ERROR: " + throwable);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int callMain(Type type, Method method) {
        List list;
        List list2 = method.params();
        if (list2.sz() == 0) {
            list = null;
        } else if (((Param)list2.get(0)).type().is(Sys.StrType.toListOf()) && (list2.sz() == 1 || ((Param)list2.get(1)).hasDefault())) {
            list = new List(Sys.ObjType, new Object[]{Env.cur().args()});
        } else {
            System.out.println("ERROR: Invalid parameters for main: " + method.signature());
            return -1;
        }
        try {
            if (method.isStatic()) {
                int n = Fan.toResult(method.callList(list));
                return n;
            }
            int n = Fan.toResult(method.callOn(type.make(), list));
            return n;
        }
        catch (Err err) {
            err.trace();
            int n = -1;
            return n;
        }
        finally {
            Fan.cleanup();
        }
    }

    static int toResult(Object object) {
        if (object instanceof Long) {
            return ((Long)object).intValue();
        }
        return 0;
    }

    static void cleanup() {
        try {
            Env.cur().out().flush();
            Env.cur().err().flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void version(String string) {
        Fan.println(string);
        Fan.println("Copyright (c) 2006-2011, Brian Frank and Andy Frank");
        Fan.println("Licensed under the Academic Free License version 3.0");
        Fan.println("");
        Fan.println("Java Runtime:");
        Fan.println("  java.version:    " + System.getProperty("java.version"));
        Fan.println("  java.vm.name:    " + System.getProperty("java.vm.name"));
        Fan.println("  java.vm.vendor:  " + System.getProperty("java.vm.vendor"));
        Fan.println("  java.vm.version: " + System.getProperty("java.vm.version"));
        Fan.println("  java.home:       " + System.getProperty("java.home"));
        Fan.println("  fan.platform:    " + Env.cur().platform());
        Fan.println("  fan.version:     " + Sys.sysPod.version());
        Fan.println("  fan.env:         " + Env.cur());
        Fan.println("  fan.home:        " + Env.cur().homeDir().osPath());
        Fan.println("");
    }

    static void pods(String string) {
        Fan.version(string);
        long l = System.nanoTime();
        List list = Pod.list();
        long l2 = System.nanoTime();
        Fan.println("");
        Fan.println("Fantom Pods [" + (l2 - l) / 1000000L + "ms]:");
        Fan.println("  Pod                 Version");
        Fan.println("  ---                 -------");
        for (int i = 0; i < list.sz(); ++i) {
            Pod pod = (Pod)list.get(i);
            Fan.println("  " + FanStr.justl(pod.name(), 18L) + "  " + FanStr.justl(pod.version().toString(), 8L));
        }
    }

    public int run(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                this.help();
                return -1;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].intern();
                if (string.length() == 0) continue;
                if (string == "-help" || string == "-h" || string == "-?") {
                    this.help();
                    return 2;
                }
                if (string == "-version") {
                    Fan.version("Fantom Launcher");
                    return 3;
                }
                if (string == "-pods") {
                    Fan.pods("Fantom Launcher");
                    return 4;
                }
                if (string.charAt(0) == '-') {
                    System.out.println("WARNING: Unknown option " + string);
                    continue;
                }
                String string2 = string;
                String[] stringArray2 = new String[stringArray.length - i - 1];
                System.arraycopy(stringArray, i + 1, stringArray2, 0, stringArray2.length);
                return this.execute(string2, stringArray2);
            }
            this.help();
            return 2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 1;
        }
    }

    void help() {
        Fan.println("Fantom Launcher");
        Fan.println("Usage:");
        Fan.println("  fan [options] <pod>::<type>.<method> [args]*");
        Fan.println("  fan [options] <filename> [args]*");
        Fan.println("Options:");
        Fan.println("  -help, -h, -?  print usage help");
        Fan.println("  -version       print version information");
        Fan.println("  -pods          list installed pods");
    }

    public static void println(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) throws Exception {
        System.exit(new Fan().run(stringArray));
    }
}

