/*
 * Decompiled with CFR 0.152.
 */
package fanx.tools;

import fan.sys.ClassType;
import fan.sys.Pod;
import fanx.emit.FPodEmit;
import fanx.emit.FTypeEmit;
import fanx.util.Box;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Jstub {
    boolean verbose;
    File outDir = new File(".");
    boolean nozip = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stub(String string) throws Exception {
        System.out.println("    Java Stub [" + string + "]");
        Pod pod = Pod.find(string, true);
        ClassType[] classTypeArray = (ClassType[])pod.types().toArray(new ClassType[pod.types().sz()]);
        ZipOutputStream zipOutputStream = this.nozip ? null : new ZipOutputStream(new FileOutputStream(new File(this.outDir, string + ".jar")));
        try {
            FPodEmit fPodEmit = FPodEmit.emit(Pod.readFPod(string));
            this.add(zipOutputStream, fPodEmit.className, fPodEmit.classFile);
            for (int i = 0; i < classTypeArray.length; ++i) {
                ClassType classType = classTypeArray[i];
                if (classType.isNative()) continue;
                FTypeEmit[] fTypeEmitArray = classType.emitToClassFiles();
                for (int j = 0; j < fTypeEmitArray.length; ++j) {
                    FTypeEmit fTypeEmit = fTypeEmitArray[j];
                    this.add(zipOutputStream, fTypeEmit.className, fTypeEmit.classFile);
                }
            }
            if (zipOutputStream != null) {
                zipOutputStream.putNextEntry(new ZipEntry("meta-inf/Manifest.mf"));
                zipOutputStream.write("Manifest-Version: 1.0\n".getBytes());
                zipOutputStream.write("Created-By: Fantom Java Stub\n".getBytes());
                zipOutputStream.closeEntry();
            }
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void add(ZipOutputStream zipOutputStream, String string, Box box) throws Exception {
        String string2 = string + ".class";
        if (this.verbose) {
            System.out.println("  " + string2);
        }
        if (zipOutputStream != null) {
            zipOutputStream.putNextEntry(new ZipEntry(string2));
            zipOutputStream.write(box.buf, 0, box.len);
            zipOutputStream.closeEntry();
        } else {
            File file = new File(this.outDir, string2);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(box.buf, 0, box.len);
            ((OutputStream)fileOutputStream).close();
        }
    }

    public int run(String[] stringArray) throws Exception {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray.length == 0) {
            this.help();
            return -1;
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n].intern();
            if (string.length() == 0) continue;
            if (string == "-help" || string == "-h" || string == "-?") {
                this.help();
                return -1;
            }
            if (string == "-v") {
                this.verbose = true;
                continue;
            }
            if (string == "-nozip") {
                this.nozip = true;
                continue;
            }
            if (string == "-d") {
                if (n + 1 >= stringArray.length) {
                    System.out.println("ERROR: must specified dir with -d option");
                    return -1;
                }
                this.outDir = new File(stringArray[++n]);
                continue;
            }
            if (string.charAt(0) == '-') {
                System.out.println("WARNING: Unknown option " + string);
                continue;
            }
            arrayList.add(string);
        }
        if (arrayList.size() == 0) {
            this.help();
            return -1;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.stub((String)arrayList.get(n));
        }
        return 0;
    }

    void help() {
        System.out.println("Java Stub");
        System.out.println("Usage:");
        System.out.println("  jstub [options] <pod> [<pod2> ...]");
        System.out.println("Options:");
        System.out.println("  -help, -h, -?  print usage help");
        System.out.println("  -d             output directory");
        System.out.println("  -v             verbose mode");
        System.out.println("  -nozip         generate classfiles instead of zip");
    }

    public static void main(String[] stringArray) throws Exception {
        System.exit(new Jstub().run(stringArray));
    }
}

