(*==========================================================================
 * Arrays
 * 
 * (c) Microsoft Corporation 2005-2007.  The interface to the module 
 * is similar to that found in versions of other ML implementations, 
 * but is not an exact match.  The type signatures in this interface
 * are an edited version of those generated automatically by running 
 * "bin\fsc.exe -i" on the implementation file.
 *=========================================================================*)

/// 1-dimensional arrays.
module Microsoft.FSharp.Collections.Array

open System
open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Collections
#if CLI_AT_MOST_1_1
open Microsoft.FSharp.Compatibility
#else
open System.Collections.Generic
#endif

/// Return the length of an array.  You can also use property arr.Length.
val length: 'a array -> int

/// Fetch an element from an array.  You can also use the syntax 'arr.[idx]'.
val get: 'a array -> int -> 'a

/// Set the value of an element in an array.  You can also use the syntax 'arr.[idx] &lt;- e'.
val set: 'a array -> int -> 'a -> unit

/// Create an array whose elements are all initially the given value
[<Obsolete("Consider using Array.create instead")>]
val make: int -> 'a -> 'a array

/// Create an array whose elements are all initially the given value.
val create: int -> 'a -> 'a array
 
/// Create an array given the dimension and a generator function to compute the elements.
val init: int -> (int -> 'a) -> 'a array

/// Create an array where the entries are initially the
/// a "default" value. For .NET reference types this will
/// be "null".  For other types behaviour is undefined if 
/// you access an entry of the array before setting it.
val zero_create: int -> 'a array
 
/// Build a new array that contains the elements of the first array followed by the elements of the second array
val append: 'a array -> 'a array -> 'a array

/// Build a new array that contains the elements of each of the given list of arrays
val concat: 'a array list -> 'a array

/// Build a new array that contains the elements of each of the given sequence of arrays
val concat_seq: #seq<'a array> -> 'a array

/// Build a new array that contains the given subrange specified by
/// starting index and length.
val sub: 'a array -> int -> int -> 'a array

/// Build a new array that contains the elements of the given array
val copy: 'a array -> 'a array

/// Fill a range of an array with the given element
val fill: 'a array -> int -> int -> 'a -> unit

/// Read a range of elements from the first array and write them into the second.
val blit: 'a array -> int -> 'a array -> int -> int -> unit

/// Create a jagged 2 dimensional array.
///
///  This member is primarily provided for compatibility with implementations 
///  of ML. F# also supports non-jagged 2D arrays - see the Array2 module and 
///  types such as "int[,]".
[<OCamlCompatibility>]
val create_matrix: int -> int -> 'a -> 'a array array

/// Create a jagged 2 dimensional array.  Synonym for create.
///
///  This member is primarily provided for compatibility with implementations 
///  of ML. F# also supports non-jagged 2D arrays - see the Array2 module and 
///  types such as "int[,]".
[<Obsolete("Consider using Array.create_matrix, or 2-dimensional array types from the Array2 module")>]
val make_matrix: int -> int -> 'a -> 'a array array

/// Returns an array with all elements permuted according to the
/// specified permutation
val permute : Permutation -> 'a array -> 'a array

(*--------------------------------------------------------------------------
 * "to_list a" returns the list "[a.(0); ...; a.(length a - 1)]"
 * "of_list l" returns the array "[| (nth l 0); ...; (nth l (length l-1)|]"
 *--------------------------------------------------------------------------*)

/// Build a list from the given array
val to_list: 'a array -> 'a list

/// Build an array from the given list
val of_list: 'a list -> 'a array

/// Apply a function to each element of the collection, threading an 'accumulator' argument
/// through the computation. If the elements are "i0...iN" then computes "f (... (f s i0)...) iN"
val fold_left: ('a -> 'b -> 'a) -> 'a -> 'b array -> 'a

/// Apply a function to each element of the array, threading an 'accumulator' argument
/// through the computation. If the elements are "i0...iN" then computes "f i0 (...(f iN s))"
val fold_right: ('a -> 'b -> 'b) -> 'a array -> 'b -> 'b

/// Apply a function to each element of the array, threading an 'accumulator' argument
/// through the computation. If the elements are "i0...iN" then computes "f (... (f i0 i1)...) iN"
/// Raises [[InvalidArgumentException]] if the array has size zero.  
val reduce_left: ('a -> 'a -> 'a) -> 'a array -> 'a
[<System.Obsolete("This function has been renamed to 'reduce_left'")>]
val fold1_left: ('a -> 'a -> 'a) -> 'a array -> 'a

/// Apply a function to each element of the array, threading an 'accumulator' argument
/// through the computation. If the elements are "i0...iN" then computes "f i0 (...(f iN-1 iN))"
/// Raises [[InvalidArgumentException]] if the array has size zero.    
val reduce_right: ('a -> 'a -> 'a) -> 'a array -> 'a
[<System.Obsolete("This function has been renamed to 'reduce_right'")>]
val fold1_right: ('a -> 'a -> 'a) -> 'a array -> 'a

/// Like fold_left, but return the intermediary and final results
val scan_left : ('b -> 'a -> 'b) -> 'b -> 'a array -> 'b array

/// Like fold_right, but return both the intermediary and final results
val scan_right : ('a -> 'b -> 'b) -> 'a array -> 'b -> 'b array

/// Like fold1_left, but return both the intermediary and final results
val scan1_left : ('a -> 'a -> 'a) -> 'a array -> 'a array

/// Like fold1_right, but return both the intermediary and final results
val scan1_right : ('a -> 'a -> 'a) -> 'a array -> 'a array
    

/// Apply the given function to each element of the array. 
val iter: ('a -> unit) -> 'a array -> unit

/// Build a new array whose elements are the results of applying the given function
/// to each of the elements of the array.
val map: ('a -> 'b) -> 'a array -> 'b array

/// Apply the given function to two arrays simultaneously. The
/// two arrays must have the same lengths, otherwise an Invalid_argument exception is
/// raised.
val iter2: ('a -> 'b -> unit) -> 'a array -> 'b array -> unit

/// Build a new collection whose elements are the results of applying the given function
/// to the corresponding elements of the two collections pairwise.  The two input
/// arrays must have the same lengths.
val map2: ('a -> 'b -> 'c) -> 'a array -> 'b array -> 'c array

/// Apply the given function to each element of the array.  The integer passed to the
/// function indicates the index of element.
val iteri: (int -> 'a -> unit) -> 'a array -> unit

/// Build a new array whose elements are the results of applying the given function
/// to each of the elements of the array. The integer index passed to the
/// function indicates the index of element being transformed.
val mapi: (int -> 'a -> 'b) -> 'a array -> 'b array

/// Test if any element of the array satisfies the given predicate.
/// If the elements are "i0...iN" 
/// then computes "p i0 or ... or p iN".
val exists: ('a -> bool) -> 'a array -> bool

/// Test if all elements of the array satisfy the given predicate.
/// If the elements are "i0...iN" and "j0...jN"
/// then computes "p i0 &amp;&amp; ... &amp;&amp; p iN".
val for_all: ('a -> bool) -> 'a array -> bool

/// Return a new collection containing only the elements of the collection
/// for which the given predicate returns "true"
val filter: ('a -> bool) -> 'a array -> 'a array

#if CLI_AT_MOST_1_1
#else
/// Split the collection into two collections, containing the 
/// elements for which the given predicate returns "true" and "false"
/// respectively 
val partition: ('a -> bool) -> 'a array -> 'a array * 'a array

/// Apply the given function to each element of the array. Return
/// the array comprised of the results "x" for each element where
/// the function returns Some(x)
val choose: ('a -> 'b option) -> 'a array -> 'b array
#endif

/// Return the first element for which the given function returns 'true'.
/// Raise [[Not_found]]/[[KeyNotFoundException]] if no such element exists.
val find: ('a -> bool) -> 'a array -> 'a

/// Return the index of the first element in the array
/// that satisfies the given predicate. Raise [[Not_found]]/[[KeyNotFoundException]] if 
/// none of the elements satisy the predicate.
val find_index : ('a -> bool) -> 'a array -> int

/// Return the index of the first element in the array
/// that satisfies the given predicate. Raise [[Not_found]]/[[KeyNotFoundException]] if 
/// none of the elements satisy the predicate.
val find_indexi : (int -> 'a -> bool) -> 'a array -> int

/// Return the first element for which the given function returns "true".
/// Return None if no such element exists.
val tryfind: ('a -> bool) -> 'a array -> 'a option

/// Return the index of the first element in the array
/// that satisfies the given predicate.
val tryfind_index : ('a -> bool) -> 'a array -> int option

/// Return the index of the first element in the array
/// that satisfies the given predicate.
val tryfind_indexi : (int -> 'a -> bool) -> 'a array -> int option


/// Apply the given function to successive elements, returning the first
/// result where function returns 'Some(x)' for some x. If the function 
/// never returns 'Some(x)' then 'None' is returned.
val first: ('a -> 'b option) -> 'a array -> 'b option

/// Sort the elements of an array, using the given comparison function as the order 
val sort: ('a -> 'a -> int) -> 'a array -> unit

/// Combine the two arrays into an array of pairs. The two arrays must have equal lengths.
val combine: 'a array -> 'b array -> ('a * 'b) array

/// Split an array of pairs into two arrays
val split: ('a * 'b) array -> ('a array * 'b array)

/// Return a new array with the elements in reverse order
val rev: 'a array -> 'a array

/// Return the sum of the results generated by applying the function to each element of the array.
val sumByInt     : ('a -> int)     -> 'a array -> int

/// Return the sum of the results generated by applying the function to each element of the array.
val sumByFloat   : ('a -> float)   -> 'a array -> float

/// Return the sum of the results generated by applying the function to each element of the array.
val sumByFloat32 : ('a -> float32) -> 'a array -> float32

/// Return the sum of the results generated by applying the function to each element of the array.
val sumByInt64   : ('a -> int64)   -> 'a array -> int64

(*--------------------------------------------------------------------------
 * The following functions relate arrays to .NET array abstractions.
 * They are only available if your are using .NET v2.0.  They correspond
 * to functionality on System.Array.
 *--------------------------------------------------------------------------*)

/// Return a view of the array as an enumerable object
val to_seq: 'a array -> seq<'a>

/// Build a new array from the given enumerable object
val of_seq: #seq<'a> -> 'a array


#if CLI_AT_MOST_1_1
#else
/// Return a view of the array as an enumerable object
[<System.Obsolete("Consider using to_seq instead")>]
val to_IEnumerable: 'a array -> seq<'a>

/// Build a new array from the given enumerable object
[<Obsolete("Consider using of_seq instead")>]
val of_IEnumerable: #seq<'a> -> 'a array

/// Return a view of the array as a .NET collection 
[<System.Obsolete("This function will be removed in a future release of F#")>]
val to_ICollection: 'a[] -> ICollection<'a>

/// Build a new array from any type that supports the .NET ICollection interface
[<Obsolete("Consider using of_IEnumerable instead")>]
val of_ICollection: #ICollection<'a> -> 'a[]

/// Build a new .NET list object for this array
[<Obsolete("Consider using List.to_ResizeArray instead")>]
val to_List: 'a[] -> System.Collections.Generic.List<'a>

/// Build a new array for a .NET list object 
[<Obsolete("Consider using List.of_seq instead")>]
val of_List: System.Collections.Generic.List<'a> -> 'a[]

/// Build a new .NET List object for this array
[<System.Obsolete("This function will be removed in a future release of F#. Use ResizeArray.of_seq instead")>]
val to_ResizeArray: 'a[] -> ResizeArray<'a>

/// Build a new array for a .NET List object 
[<System.Obsolete("This function will be removed in a future release of F#. Use Array.of_seq instead")>]
val of_ResizeArray: ResizeArray<'a> -> 'a[]
#endif

/// Pin the given array for the duration of a single call to the given function.  A native pointer to
/// the first element in the array is passed to the given function.  Cleanup the GCHandle associated with the 
/// pin when the function completes, even if an exception is raised.
val inline pin: 'a[] -> ('a nativeptr -> 'b) -> 'b

/// As for Array.pin, except that the caller is responsible for calling Free on the returned GCHandle in order
/// to release the pin.
val inline pin_unscoped: 'a[] -> 'a nativeptr *  System.Runtime.InteropServices.GCHandle
