// (c) Microsoft Corporation 2005-2007.  

#light

namespace Microsoft.FSharp.Compatibility

module CompatArray  = 

    open Microsoft.FSharp.Core
    open Microsoft.FSharp.Collections
    open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators

    let inline (-) (x:int) (y:int) = (# "sub" x y : int #)
    let inline (+) (x:int) (y:int) = (# "add" x y : int #)

    module Array = 

        let inline length (arr: 'a array) =  (# "ldlen conv.i4" arr : int #)  
        let inline get (arr: 'a array) (n:int) =  (# "ldelem.erasable !0" type ('a) arr n : 'a #)  
        let inline set (arr: 'a array) (n:int) (x:'a) =  (# "stelem.erasable !0" type ('a) arr n x #)  
        let inline zero_create (n:int) = (# "newarr.erasable !0" type ('a) n : 'a array #)


    (* Define the primitive operations. *)
    (* Note: the "type" syntax is for the type parameter for inline *)
    (* polymorphic IL. This helps the compiler inline these fragments, *)
    (* i.e. work out the correspondence between IL and F# type variables. *)
    let
#if CLI_AT_MOST_1_1
     inline
#endif
       length (arr: 'a[]) =  (# "ldlen conv.i4" arr : int #)  

    let
#if CLI_AT_MOST_1_1
     inline
#endif
       get (arr: 'a[]) (n:int) =  (# "ldelem.any !0" type ('a) arr n : 'a #)

    #if CLI_AT_LEAST_2_0
    let set (arr: 'a[]) (n:int) (x:'a) =  (# "stelem.any !0" type ('a) arr n x #)
    #else
    // The above do not work for value types when compiling without generics, since 
    // ILX is not able to erase the use of stelem.any
    let inline set (arr: 'a[]) (n:int) (x:'a) =  (# "stobj !0" type ('a) (# "ldelema !0" type ('a) arr n : System.UIntPtr #) x #)
#endif

    let
#if CLI_AT_MOST_1_1
     inline
#endif
       zero_create (n:int) = (# "newarr !0" type ('a) n : 'a[] #)

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     make  (n:int) x =
        let arr = zero_create n 
        for i = 0 to n - 1 do 
          (set arr i x)
        done;
        arr

    let
#if CLI_AT_MOST_1_1
     inline
#endif
       create (n:int) x = make n x

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     init (n:int) f = 
        let arr = zero_create n  
        for i = 0 to n - 1 do 
          set arr i (f i)
        done;
        arr

    let
#if CLI_AT_MOST_1_1
     inline
#endif
       nonNil x = match x with [] -> false | _ -> true

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     concat arrs =
        let rec list_fold_left f acc l = 
          match l with 
            [] -> acc
          | (h::t) -> list_fold_left f (f acc h) t 
        let lenall = list_fold_left (fun x y -> x + length y) 0 arrs 
        let res = zero_create lenall 
        let mutable n = 0 
        let mutable curr = arrs 
        while nonNil curr do
          let arr::t = curr 
          let len = length arr 
          for i = 0 to len - 1 do 
              set res (n + i) (get arr i )
          n <- n + len;
          curr <- t;
        done;
        res

    let
#if CLI_AT_MOST_1_1
     inline
#endif
       append arr1 arr2 = concat [arr1; arr2]

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     sub arr (start:int) (len:int) =
        let res = zero_create len   
        for i = 0 to len - 1 do 
            set res i (get arr (start + i))
        res

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     fill arr (start:int) (len:int) x =
        for i = start to start + len - 1 do 
            (set arr i x)

    let
#if CLI_AT_MOST_1_1
     inline
#endif
       copy arr = concat [arr]

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     blit arr1 (start1:int) arr2 (start2:int) (len:int) =
        for i = 0 to len - 1 do 
            set arr2 (start2+i) (get arr1 (start1 + i))

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     to_list arr =
        let len = length arr 
        let mutable res = [] 
        for i = len - 1 downto 0 do 
            res <- (get arr i) :: res
        res
      
    let
#if CLI_AT_MOST_1_1
     inline
#endif
     nonempty x = match x with [] -> false | _ -> true

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     list_length l = 
        let mutable res = 0 
        let mutable curr = l 
        while (nonempty curr) do 
            res <- res + 1;
            curr <- curr.(::).1
        res

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     of_list l =
        let len = list_length l 
        let res = zero_create len  
        let mutable lref = l 
        for i = 0 to len - 1 do 
            let h :: t = lref  
            set res i h;
            lref <- t
        res

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     iter f arr =
        let len = length arr 
        for i = 0 to len - 1 do 
            f (get arr i)

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     map f arr =
        let len = length arr 
        let res = zero_create len 
        for i = 0 to len - 1 do 
            set res i (f (get arr i))
        res

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     iteri f arr =
        let len = length arr 
        for i = 0 to len - 1 do 
            f i (get arr i)


    let
#if CLI_AT_MOST_1_1
     inline
#endif
     mapi f arr =
        let len = length arr 
        let res = zero_create len  
        for i = 0 to len - 1 do 
            set res i  (f i (get arr i))
        res

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     fold_left f acc arr =
        let mutable res = acc 
        let len = length arr 
        for i = 0 to len - 1 do 
            res <- f res (get arr i)
        res

    let
#if CLI_AT_MOST_1_1
     inline
#endif
     fold_right f arr acc =
        let mutable res = acc 
        let len = length arr 
        for i = len - 1 downto 0 do 
            res <- f (get arr i) res
        res



#if CLI_AT_MOST_1_1
    let inline of_array x =
        let res = zero_create (Array.length x) 
        for i = 0 to Array.length x - 1 do
            set res i (Array.get x i)
        res

    let inline to_array x =
        let res = Array.zero_create (length x) 
        for i = 0 to length x - 1 do
            Array.set res i (get x i)
        res
    #else
    let of_array (x: 'a array) = (x : 'a [])
    let to_array (x: 'a[]) = (x : 'a array)
#endif

        
