// (c) Microsoft Corporation 2005-2007.  

#light

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
open Microsoft.FSharp.Core.Operators

/// ML-like operations on 32-bit System.Single floating point numbers.
[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Float32 = 

    let add (x:float32) (y:float32) = (# "add" x y : float32 #) 
    let sub (x:float32) (y:float32) = (# "sub" x y : float32 #) 
    let mul (x:float32) (y:float32) = (# "mul" x y : float32 #)
    let div (x:float32) (y:float32) = (# "div" x y : float32 #)
    let neg (x:float32) =  (# "neg" x : float32 #) 

    let compare (x:float32) y = compare x y

    let of_int (n:int) =  (# "conv.r4" n : float32 #)
    let to_int (x:float32) = (# "conv.i4" x : int #)

    let of_int64 (x:int64) = (# "conv.r4" x : float32 #)
    let to_int64 (x:float32) = (# "conv.i8" x : int64 #)

    let of_int32 (x:int32) = (# "conv.r4" x : float32 #)
    let to_int32 (x:float32) = (# "conv.i4" x : int32 #)

    let of_float (x:float) = (# "conv.r4" x : float32 #)
    let to_float (x:float32) = (# "conv.r8" x : float #)

    let to_string (x:float32) = (box x).ToString()
    let of_string (s:string) = 
      (* Note System.Single.Parse doesn't handle -0.0 correctly (it returns +0.0) *)
      let s = s.Trim()  
      let l = s.Length 
      let p = 0 
      let p,sign = if (l >= p + 1 && s.[p] = '-') then 1,false else 0,true 
      let n = 
        try 
          if p >= l then raise (new System.FormatException()) 
          System.Single.Parse(s.[p..],System.Globalization.CultureInfo.InvariantCulture)
        with :? System.FormatException -> failwith "Float32.of_string"
      if sign then n else -n

    let of_bits x = Int32.float32_of_bits x
    let to_bits x = Int32.bits_of_float32 x


