// (c) Microsoft Corporation 2005-2007. 

#light

namespace Microsoft.FSharp.Math

open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Math

module Notation = 

    type matrix = Matrix<float>
    type vector = Vector<float>
    type rowvec = RowVector<float>
    type complex = Complex
  
#if CLI_AT_MOST_1_1
#else
    module Generic = 
      type 'a matrix = Matrix<'a>
      type 'a vector = Vector<'a>
      type 'a rowvec = RowVector<'a>
      type complex = Complex
    
      let complex x y = Complex.mkRect (x,y)
      let matrix ll = Matrix.Generic.of_seq ll
      let vector l = Vector.Generic.of_seq  l
      let rowvec l = RowVector.Generic.of_seq l
      let S x = Matrix.Generic.of_scalar x
      let RV x = Matrix.Generic.of_rowvec x 
      let V x  = Matrix.Generic.of_vector x
      let M2V x = Matrix.Generic.to_vector x
      let M2RV x = Matrix.Generic.to_rowvec x
      let M2S x = Matrix.Generic.to_scalar x
#endif
  

    let complex x y = Complex.mkRect (x,y)
    // Notational conveniences
    let matrix ll = Matrix.of_seq ll
    let vector l = Vector.of_seq l
    let rowvec l = RowVector.of_seq l
    let S x = Matrix.of_scalar x
    let RV x = Matrix.of_rowvec x 
    let V x  = Matrix.of_vector x
    let M2V x = Matrix.to_vector x
    let M2RV x = Matrix.to_rowvec x
    let M2S x = Matrix.to_scalar x

