(* -------------------------------------------------------------------- 
 * (c) Microsoft Corporation. All rights reserved 
 * -------------------------------------------------------------------- *)

(** The IL Binary writer *)  
(*F# 
module Microsoft.Research.AbstractIL.BinaryWriter 
open Microsoft.Research.AbstractIL 
open Microsoft.Research.AbstractIL.Internal 
module Il = Microsoft.Research.AbstractIL.IL 
F#*)  

open Il

type signer

(** Write a binary to the file system. Optionally write a PDB file too. *)
val write_binary: 
    (*F# file:       F#*) string  ->
    (*F# debugFile:  F#*) string option ->
    (*F# signer:     F#*) signer option ->
    (*F# minVersion: F#*) Il.version_info option ->
    Il.modul -> 
    unit

type options =
 { mscorlib: scope_ref;
   manager: manager option;
   pdbfile: string option;
   signer : signer option;
   desiredMetadataVersionOpt : version_info option;
   fixupOverlappingSequencePoints : bool }

val defaults : options

(** Write a binary to the file system. Extra configuration parameters can also be specified. *)
val write_binary_ex: 
    (*F# filename: F#*) string ->
    (*F# options:  F#*) options ->
    (*F# input:    F#*) Il.modul -> 
    unit


(** Tables of mappings for write_binary_and_report_mappings *)
(*F#
[<StructuralEquality(false); StructuralComparison(false)>]
F#*)
type mappings =  
    { tdefMap: type_def list * type_def -> int32;
      fdefMap: type_def list * type_def -> field_def -> int32;
      mdefMap: type_def list * type_def -> method_def -> int32;
      propertyMap: type_def list * type_def -> property_def -> int32;
      eventMap: type_def list * type_def -> event_def -> int32 }

(*
/// This version of write_binary reports the token numbers for the definitions
/// in the new binaries.
*)
val write_binary_and_report_mappings: 
    (*F# filename: F#*) string ->
    (*F# options:  F#*) options ->
    (*F# input:    F#*) Il.modul -> 
              mappings

val signerPublicKey: signer -> bytes
val signerOpenPublicKeyFile: string -> signer
val signerOpenPublicKey: Bytes.bytes -> signer
val signerOpenKeyPairFile: string -> signer
val signerOpenKeyContainer: string -> signer
val signerClose: signer -> unit
val signerSignatureSize: signer -> int
val signerSignFile: string -> signer -> unit
val signerFullySigned: signer -> bool

(** If this is set a report of times is sent to the Ildiag diagnostics channel *)
val showTimes : bool ref


