// (c) Microsoft Corporation 2005-2007. 

#light

namespace Microsoft.FSharp

module Idioms = 

    open System
    open Microsoft.FSharp.Core
    open Microsoft.FSharp.Core
    open Microsoft.FSharp.Core.LanguagePrimitives
    open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
    open Microsoft.FSharp.Core.Operators
    open Microsoft.FSharp.Collections
    open Microsoft.FSharp.Control
    open Microsoft.FSharp.Primitives.Basics
    open Microsoft.FSharp.Primitives.Basics.List

    let box x = Microsoft.FSharp.Core.Operators.box x
    let unbox x = Microsoft.FSharp.Core.Operators.unbox x
    let lock (lockobj :> obj) f  = 
      System.Threading.Monitor.Enter(lockobj);
      try f()
      finally
        System.Threading.Monitor.Exit(lockobj)

    let foreachE (e :> System.Collections.IEnumerator) (f : 'a -> unit) = 
      while (e.MoveNext()) do
        f (unbox e.Current);
      done

    let foreach (ie :> System.Collections.IEnumerable) (f : 'a -> unit) = 
      foreachE (ie.GetEnumerator()) f


    #if CLI_AT_LEAST_2_0
    let foreachEG (e :> System.Collections.Generic.IEnumerator<'a>) (f : 'a -> unit) = 
      while (e.MoveNext()) do
        f e.Current;
      done


    let foreachG (ie :> System.Collections.Generic.IEnumerable<'a>) (f : 'a -> unit) = 
      foreachEG (ie.GetEnumerator()) f


    #endif



    let using (ie :> System.IDisposable) f = 
      try f(ie)
      finally ie.Dispose()

    let EnumToInt x = Enum.to_int(x)
    let IntToEnum x = Enum.of_int(x)
    let CombineEnumFlags l = Enum.combine(l)
    let TestEnumFlag x y = Enum.test x y

    type 'a typ = 'a Microsoft.FSharp.Core.ReifiedType 

    #if CLI_AT_LEAST_2_0
    let inline typeof<'a> () : ReifiedType<'a> = { result=Microsoft.FSharp.Core.Operators.typeof<'a> }
    #else
    let inline typeof< $a > () : ReifiedType< ($a) > = { result=Microsoft.FSharp.Core.Operators.typeof< ($a) > }
    #endif

    type 'a sizeof = { result: int }

    #if CLI_AT_LEAST_2_0
    let sizeof () : sizeof<'a> =
        { result = (# "sizeof !0" type('a) : int #) }
    #else
    let inline sizeof () : sizeof< $a > =
        { result = (# "sizeof !0" type($a) : int #) }
    #endif

    #if CLI_AT_LEAST_2_0
    let ParamArray l = 
    #else
    let inline ParamArray l = 
    #endif
      Microsoft.FSharp.Compatibility.CompatArray.of_list l

    //-------------------------------------------------------------------------
    // Events


    type IEvent<'a> = Microsoft.FSharp.Control.IEvent<'a>
    type IDelegateEvent<'del,'args> = Microsoft.FSharp.Control.IDelegateEvent<'del,'args>

    type Handler<'a> =  Microsoft.FSharp.Control.Handler<'a>
    type IHandlerEvent<'a> = Microsoft.FSharp.Control.IHandlerEvent<'a>

    // deprecated
    [<Sealed>]
    type EventListeners<'a>() = 
        let mutable listeners = ([] : (Handler<'a>) list)
        let add d = listeners <- d :: listeners 
        let remove d1 = listeners <- filter (fun d2 -> not (PhysicalEquality d1 d2)) listeners 
        let ev = { new IHandlerEvent<_> 
                   with Add(f) = add(new Handler<'a>(fun _ x -> f x) )
                   and  AddHandler(x) = add(x) 
                   and  RemoveHandler(x) = remove(x) } 
        member l.Fire(x : 'a) = listeners |> iter (fun d -> ignore(d.Invoke((null:obj),x))) 
        member l.Event = ev
