
#include "oipfapplicationmanager.h"

#define kOAM_ID_PROPERTY_ON_LOW_MEMORY                  0
#define kOAM_NUM_PROPERTY_IDENTIFIERS                   1

#define kOAM_ID_METHOD_GET_OWNER_APPLICATION            0
#define kOAM_NUM_METHOD_IDENTIFIERS                     1

bool            v_bOAMIdentifiersInitialized = false;

NPIdentifier    v_OAMPropertyIdentifiers[kOAM_NUM_PROPERTY_IDENTIFIERS];
const NPUTF8 *  v_OAMPropertyNames[kOAM_NUM_PROPERTY_IDENTIFIERS] = {
    "onLowMemory"
	};

NPIdentifier    v_OAMMethodIdentifiers[kOAM_NUM_METHOD_IDENTIFIERS];
const NPUTF8 *  v_OAMMethodNames[kOAM_NUM_METHOD_IDENTIFIERS] = {
    "getOwnerApplication"
};




static  void    OAMinitializeIdentifiers(void)
{
    sBrowserFuncs->getstringidentifiers( v_OAMPropertyNames, kOAM_NUM_PROPERTY_IDENTIFIERS, v_OAMPropertyIdentifiers );
    sBrowserFuncs->getstringidentifiers( v_OAMMethodNames,   kOAM_NUM_METHOD_IDENTIFIERS,   v_OAMMethodIdentifiers );
}

NPClass  stOAMclass;
NPClass* pOAMclass = NULL;

NPClass* fillOAMpclass(void)
{
    TRACEINFO;
    if (pOAMclass == NULL)
    {
        stOAMclass.allocate          = OAM_Allocate;
        stOAMclass.deallocate        = OAM_Deallocate;
        stOAMclass.invalidate        = OAM_Invalidate;
        stOAMclass.hasMethod         = OAM_HasMethod;
        stOAMclass.invoke            = OAM_Invoke;
        stOAMclass.invokeDefault     = OAM_InvokeDefault;
        stOAMclass.hasProperty       = OAM_HasProperty;
        stOAMclass.getProperty       = OAM_GetProperty;
        stOAMclass.setProperty       = OAM_SetProperty;
        stOAMclass.removeProperty    = OAM_RemoveProperty;
        stOAMclass.enumerate         = OAM_Enumerate;
        pOAMclass = &stOAMclass;
    }

    return pOAMclass;
}


NPObject *          OAM_Allocate(NPP npp, NPClass *theClass)
{
    TRACEINFO;

    NPObject* newapplication = NULL;
    if (!v_bOAMIdentifiersInitialized)
    {
        v_bOAMIdentifiersInitialized = true;
        OAMinitializeIdentifiers();
    }

    newapplication = malloc(sizeof(NPObject));

    return newapplication;
}

  void        OAM_Deallocate(NPObject* obj)
{
    TRACEINFO;
    free(obj);
    return;
}

  void        OAM_Invalidate(NPObject* obj)
{
    TRACEINFO;
    return;
}

  bool        OAM_HasMethod(NPObject* obj, NPIdentifier name)
{
    TRACEINFO;

    bool result = false;
    int i = 0;
    NPUTF8* utf8methodname = (char*)sBrowserFuncs->utf8fromidentifier(name);
    while ((i < kOAM_NUM_METHOD_IDENTIFIERS) && (result == false))
    {
        if ( name == v_OAMMethodIdentifiers[i] )
        {
            result= true;
        }
        i++;
    }
	printf("\tOAM has method \"%s\" : %s \n", utf8methodname, booltostr(result));

    return result;
}

bool        OAM_Invoke(NPObject* obj, NPIdentifier name, const NPVariant* args, uint32_t argCount, NPVariant* result)
{
    TRACEINFO;
	//OAM_ObjectMain * pMainObj = reinterpret_cast<tWOTVe_OAM_ObjectMain*>(obj);
	bool fctresult = false;
    if (name == v_OAMMethodIdentifiers[kOAM_ID_METHOD_GET_OWNER_APPLICATION])
    {
		OAM_ObjectMain_Invoke_GetOwnerApplication(obj, args, argCount);
		fctresult = true;
    }
    else
    {
        printf("OAM_ObjectMain_Invoke(): method not found\n");
        fctresult = false;
    }
    return fctresult;
}

 bool        OAM_InvokeDefault(NPObject *npobj, const NPVariant *args, uint32_t argCount, NPVariant *result)
{
    TRACEINFO;
    return true;
}

  bool        OAM_HasProperty(NPObject* obj, NPIdentifier name)
{
    TRACEINFO;
    bool result = false;
    NPUTF8* utf8propertyname = (char*)sBrowserFuncs->utf8fromidentifier(name);

    int i = 0;
    while ((i < kOAM_NUM_PROPERTY_IDENTIFIERS) && (result == false))
    {
        if ( name == v_OAMPropertyIdentifiers[i] )
        {
            result= true;
        }
        i++;
    }

    printf("\tOAM has property \"%s\" : %s \n", utf8propertyname, booltostr(result));
    return result;
}

  bool        OAM_GetProperty(NPObject* obj, NPIdentifier name, NPVariant* result)
{
    TRACEINFO;
    return true;
}

  bool        OAM_SetProperty(NPObject *obj, NPIdentifier name, const NPVariant *value)
{
    TRACEINFO;
    return true;
}

 bool        OAM_RemoveProperty(NPObject *npobj, NPIdentifier name)
{
    TRACEINFO;
    return true;
}


 bool        OAM_Enumerate(NPObject *npobj, NPIdentifier **value, uint32_t *count)
{
    TRACEINFO;
    return true;
}

/** implementation **/
void OAM_ObjectMain_Invoke_GetOwnerApplication(NPObject* obj,const NPVariant* args, uint32_t argCount)
{
	TRACEINFO;
	NOTIMPLEMENTED;
}
