/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilationInitializer;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationNotNecessary;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpecProvider;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;

class SelectiveCompiler
implements Compiler<JavaCompileSpec> {
    private static final Logger LOG = Logging.getLogger(SelectiveCompiler.class);
    private final IncrementalTaskInputs inputs;
    private final PreviousCompilation previousCompilation;
    private final CleaningJavaCompiler cleaningCompiler;
    private final Compiler<JavaCompileSpec> rebuildAllCompiler;
    private final RecompilationSpecProvider recompilationSpecProvider;
    private final IncrementalCompilationInitializer incrementalCompilationInitializer;
    private final ClasspathSnapshotProvider classpathSnapshotProvider;

    public SelectiveCompiler(IncrementalTaskInputs inputs, PreviousCompilation previousCompilation, CleaningJavaCompiler cleaningCompiler, Compiler<JavaCompileSpec> rebuildAllCompiler, RecompilationSpecProvider recompilationSpecProvider, IncrementalCompilationInitializer compilationInitializer, ClasspathSnapshotProvider classpathSnapshotProvider) {
        this.inputs = inputs;
        this.previousCompilation = previousCompilation;
        this.cleaningCompiler = cleaningCompiler;
        this.rebuildAllCompiler = rebuildAllCompiler;
        this.recompilationSpecProvider = recompilationSpecProvider;
        this.incrementalCompilationInitializer = compilationInitializer;
        this.classpathSnapshotProvider = classpathSnapshotProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkResult execute(JavaCompileSpec spec) {
        Timer clock = Time.startTimer();
        CurrentCompilation currentCompilation = new CurrentCompilation(this.inputs, spec, this.classpathSnapshotProvider);
        RecompilationSpec recompilationSpec = this.recompilationSpecProvider.provideRecompilationSpec(currentCompilation, this.previousCompilation);
        if (recompilationSpec.isFullRebuildNeeded()) {
            LOG.info("Full recompilation is required because {}. Analysis took {}.", (Object)recompilationSpec.getFullRebuildCause(), (Object)clock.getElapsed());
            return this.rebuildAllCompiler.execute((CompileSpec)spec);
        }
        this.incrementalCompilationInitializer.initializeCompilation(spec, recompilationSpec);
        if (Iterables.isEmpty((Iterable)spec.getSourceFiles()) && spec.getClasses().isEmpty()) {
            LOG.info("None of the classes needs to be compiled! Analysis took {}. ", (Object)clock.getElapsed());
            return new RecompilationNotNecessary();
        }
        try {
            WorkResult workResult = this.cleaningCompiler.getCompiler().execute((CompileSpec)spec);
            return workResult;
        }
        finally {
            Collection<String> classesToCompile = recompilationSpec.getClassesToCompile();
            LOG.info("Incremental compilation of {} classes completed in {}.", (Object)classesToCompile.size(), (Object)clock.getElapsed());
            LOG.debug("Recompiled classes {}", classesToCompile);
        }
    }
}

