/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Iterator;
import java.util.Set;
import org.gradle.cache.internal.locklistener.FileLockPacketPayload;
import org.gradle.cache.internal.locklistener.FileLockPacketType;
import org.gradle.cache.internal.locklistener.GracefullyStoppedException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockCommunicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLockCommunicator.class);
    private static final String SOCKET_OPERATION_NOT_PERMITTED_ERROR_MESSAGE = "Operation not permitted";
    private final DatagramSocket socket;
    private final InetAddressFactory addressFactory;
    private volatile boolean stopped;

    public FileLockCommunicator(InetAddressFactory addressFactory) {
        this.addressFactory = addressFactory;
        try {
            this.socket = new DatagramSocket(0, addressFactory.getLocalBindingAddress());
        }
        catch (SocketException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pingOwner(int ownerPort, long lockId, String displayName) {
        try {
            byte[] bytesToSend = FileLockPacketPayload.encode(lockId, FileLockPacketType.UNLOCK_REQUEST);
            Iterator i$ = this.addressFactory.getCommunicationAddresses().iterator();
            while (i$.hasNext()) {
                InetAddress address = (InetAddress)i$.next();
                try {
                    this.socket.send(new DatagramPacket(bytesToSend, bytesToSend.length, address, ownerPort));
                }
                catch (IOException e) {
                    if (e.getMessage() == null) throw e;
                    if (!e.getMessage().startsWith(SOCKET_OPERATION_NOT_PERMITTED_ERROR_MESSAGE)) throw e;
                    LOGGER.debug("Failed attempt to ping owner of lock for {} (lock id: {}, port: {}, address: {})", new Object[]{displayName, lockId, ownerPort, address});
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to ping owner of lock for %s (lock id: %s, port: %s)", displayName, lockId, ownerPort), e);
        }
    }

    public DatagramPacket receive() throws GracefullyStoppedException {
        try {
            byte[] bytes = new byte[10];
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
            this.socket.receive(packet);
            return packet;
        }
        catch (IOException e) {
            if (!this.stopped) {
                throw new RuntimeException(e);
            }
            throw new GracefullyStoppedException();
        }
    }

    public FileLockPacketPayload decode(DatagramPacket receivedPacket) {
        try {
            return FileLockPacketPayload.decode(receivedPacket.getData(), receivedPacket.getLength());
        }
        catch (IOException e) {
            if (!this.stopped) {
                throw new RuntimeException(e);
            }
            throw new GracefullyStoppedException();
        }
    }

    public void confirmUnlockRequest(SocketAddress address, long lockId) {
        try {
            byte[] bytes = FileLockPacketPayload.encode(lockId, FileLockPacketType.UNLOCK_REQUEST_CONFIRMATION);
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
            packet.setSocketAddress(address);
            this.socket.send(packet);
        }
        catch (IOException e) {
            if (!this.stopped) {
                throw new RuntimeException(e);
            }
            throw new GracefullyStoppedException();
        }
    }

    public void confirmLockRelease(Set<SocketAddress> addresses, long lockId) {
        byte[] bytes = FileLockPacketPayload.encode(lockId, FileLockPacketType.LOCK_RELEASE_CONFIRMATION);
        for (SocketAddress address : addresses) {
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
            packet.setSocketAddress(address);
            LOGGER.debug("Confirming lock release to Gradle process at port {} for lock with id {}.", (Object)packet.getPort(), (Object)lockId);
            try {
                this.socket.send(packet);
            }
            catch (IOException e) {
                if (this.stopped) continue;
                LOGGER.debug("Failed to confirm lock release to Gradle process at port {} for lock with id {}.", (Object)packet.getPort(), (Object)lockId);
            }
        }
    }

    public void stop() {
        this.stopped = true;
        this.socket.close();
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }
}

