/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.range.forLoop;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.range.forLoop.AbstractForInProgressionOrRangeLoopGenerator;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0012\u001a\u00020\fH\u0004J\b\u0010\u0013\u001a\u00020\fH$R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/codegen/range/forLoop/AbstractForInRangeLoopGenerator;", "Lorg/jetbrains/kotlin/codegen/range/forLoop/AbstractForInProgressionOrRangeLoopGenerator;", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "forExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "step", "", "(Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;Lorg/jetbrains/kotlin/psi/KtForExpression;I)V", "getStep", "()I", "assignToLoopParameter", "", "beforeLoop", "checkEmptyLoop", "loopExit", "Lorg/jetbrains/org/objectweb/asm/Label;", "checkPostConditionAndIncrement", "incrementLoopVariable", "storeRangeStartAndEnd", "backend"})
public abstract class AbstractForInRangeLoopGenerator
extends AbstractForInProgressionOrRangeLoopGenerator {
    private final int step;

    @Override
    public void beforeLoop() {
        super.beforeLoop();
        this.storeRangeStartAndEnd();
    }

    protected abstract void storeRangeStartAndEnd();

    @Override
    public void checkEmptyLoop(@NotNull Label loopExit) {
        Intrinsics.checkParameterIsNotNull((Object)loopExit, (String)"loopExit");
        this.loopParameter().put(this.getAsmElementType(), this.getV());
        this.getV().load(this.getEndVar(), this.getAsmElementType());
        if (this.getAsmElementType().getSort() == 7) {
            this.getV().lcmp();
            if (this.step > 0) {
                this.getV().ifgt(loopExit);
            } else {
                this.getV().iflt(loopExit);
            }
        } else if (this.step > 0) {
            this.getV().ificmpgt(loopExit);
        } else {
            this.getV().ificmplt(loopExit);
        }
    }

    @Override
    protected void assignToLoopParameter() {
    }

    @Override
    protected void checkPostConditionAndIncrement(@NotNull Label loopExit) {
        Intrinsics.checkParameterIsNotNull((Object)loopExit, (String)"loopExit");
        this.checkPostCondition(loopExit);
        this.incrementLoopVariable();
    }

    protected final void incrementLoopVariable() {
        if (this.getLoopParameterType() == Type.INT_TYPE) {
            this.getV().iinc(this.getLoopParameterVar(), this.step);
        } else {
            StackValue loopParameter = this.loopParameter();
            loopParameter.put(this.getAsmElementType(), this.getV());
            AsmUtil.genIncrement(this.getAsmElementType(), this.step, this.getV());
            loopParameter.store(StackValue.onStack(this.getAsmElementType()), this.getV());
        }
    }

    protected final int getStep() {
        return this.step;
    }

    public AbstractForInRangeLoopGenerator(@NotNull ExpressionCodegen codegen, @NotNull KtForExpression forExpression, int step) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)codegen, (String)"codegen");
        Intrinsics.checkParameterIsNotNull((Object)forExpression, (String)"forExpression");
        super(codegen, forExpression);
        this.step = step;
        boolean bl2 = bl = this.step == 1 || this.step == -1;
        if (_Assertions.ENABLED && !bl) {
            String string = "'step' should be either 1 or -1: " + this.step;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }
}

