/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchStatement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class PsiSwitchStatementImpl
extends CompositePsiElement
implements PsiSwitchStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiSwitchStatementImpl");

    public PsiSwitchStatementImpl() {
        super(SWITCH_STATEMENT);
    }

    @Override
    public PsiExpression getExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(43);
    }

    @Override
    public PsiCodeBlock getBody() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(44);
    }

    @Override
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    @Override
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 42: {
                return this.findChildByType(SWITCH_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 43: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 44: 
        }
        return this.findChildByType(CODE_BLOCK);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == SWITCH_KEYWORD) {
            return 42;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 43;
        }
        if (child.getElementType() == CODE_BLOCK) {
            return 44;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiSwitchStatementImpl.$$$reportNull$$$0(0);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitSwitchStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiSwitchStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiSwitchStatementImpl", "accept"));
    }
}

