/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.util.AstUtil;

public class JsForIn
extends SourceInfoAwareJsNode
implements JsStatement {
    private JsStatement body;
    private JsExpression iterExpression;
    private JsExpression objectExpression;
    private final JsName iterVarName;

    public JsForIn() {
        this(null);
    }

    public JsForIn(JsName iterVarName) {
        this.iterVarName = iterVarName;
    }

    public JsForIn(JsName iterVarName, JsExpression iterExpression, JsExpression objectExpression, JsStatement body) {
        this.iterVarName = iterVarName;
        this.iterExpression = iterExpression;
        this.objectExpression = objectExpression;
        this.body = body;
    }

    public JsStatement getBody() {
        return this.body;
    }

    public JsExpression getIterExpression() {
        return this.iterExpression;
    }

    public JsName getIterVarName() {
        return this.iterVarName;
    }

    public JsExpression getObjectExpression() {
        return this.objectExpression;
    }

    public void setBody(JsStatement body) {
        this.body = body;
    }

    public void setIterExpression(JsExpression iterExpression) {
        this.iterExpression = iterExpression;
    }

    public void setObjectExpression(JsExpression objectExpression) {
        this.objectExpression = objectExpression;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitForIn(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        if (this.iterExpression != null) {
            visitor2.acceptLvalue(this.iterExpression);
        }
        visitor2.accept(this.objectExpression);
        visitor2.accept(this.body);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            if (this.iterExpression != null) {
                this.iterExpression = v.acceptLvalue(this.iterExpression);
            }
            this.objectExpression = v.accept(this.objectExpression);
            this.body = v.acceptStatement(this.body);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsForIn deepCopy() {
        JsStatement bodyCopy = AstUtil.deepCopy(this.body);
        JsExpression iterCopy = AstUtil.deepCopy(this.iterExpression);
        JsExpression objectCopy = AstUtil.deepCopy(this.objectExpression);
        return new JsForIn(this.iterVarName, iterCopy, objectCopy, bodyCopy).withMetadataFrom(this);
    }
}

