/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.coroutines.experimental;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.coroutines.experimental.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.CommonPool;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.CoroutineDispatcher;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.DefaultExecutor;
import org.jetbrains.kotlin.kotlinx.coroutines.experimental.TimeSourceKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\nH\u0082\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0003J\r\u0010\u0017\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\r\u0010\u0005\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b\u001fR\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/CommonPool;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/experimental/CoroutineDispatcher;", "()V", "_pool", "Ljava/util/concurrent/Executor;", "usePrivatePool", "", "Try", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createPlainPool", "Ljava/util/concurrent/ExecutorService;", "createPool", "defaultParallelism", "", "dispatch", "", "context", "Lkotlin/coroutines/experimental/CoroutineContext;", "Ljava/lang/Runnable;", "getOrCreatePoolSync", "restore", "restore$kotlinx_coroutines_core", "shutdown", "timeout", "", "shutdown$kotlinx_coroutines_core", "toString", "", "usePrivatePool$kotlinx_coroutines_core", "kotlinx-coroutines-core"})
public final class CommonPool
extends CoroutineDispatcher {
    private static boolean usePrivatePool;
    private static volatile Executor _pool;
    public static final CommonPool INSTANCE;

    private final <T> T Try(Function0<? extends T> block) {
        Object object;
        try {
            object = block.invoke();
        }
        catch (Throwable e) {
            object = null;
        }
        return (T)object;
    }

    private final ExecutorService createPool() {
        ExecutorService $i$a$2$let;
        CommonPool it;
        Class<?> $i$a$1$Try;
        CommonPool this_$iv = this;
        try {
            $i$a$1$Try = Class.forName("java.util.concurrent.ForkJoinPool");
        }
        catch (Throwable e$iv) {
            $i$a$1$Try = null;
        }
        Class<?> clazz = $i$a$1$Try;
        if (clazz == null) {
            return this.createPlainPool();
        }
        Class<?> fjpClass = clazz;
        if (!usePrivatePool) {
            ExecutorService e$iv;
            this_$iv = this;
            try {
                Method method = fjpClass.getMethod("commonPool", new Class[0]);
                Object object = method != null ? method.invoke(null, new Object[0]) : null;
                if (!(object instanceof ExecutorService)) {
                    object = null;
                }
                e$iv = (ExecutorService)object;
            }
            catch (Throwable e$iv2) {
                e$iv = null;
            }
            ExecutorService executorService = e$iv;
            if (executorService != null) {
                it = this_$iv = executorService;
                return it;
            }
        }
        this_$iv = this;
        try {
            Object obj = fjpClass.getConstructor(Integer.TYPE).newInstance(INSTANCE.defaultParallelism());
            if (!(obj instanceof ExecutorService)) {
                obj = null;
            }
            $i$a$2$let = (ExecutorService)obj;
        }
        catch (Throwable e$iv) {
            $i$a$2$let = null;
        }
        ExecutorService executorService = $i$a$2$let;
        if (executorService != null) {
            ExecutorService executorService2 = executorService;
            it = executorService2;
            return it;
        }
        return this.createPlainPool();
    }

    private final ExecutorService createPlainPool() {
        AtomicInteger threadId = new AtomicInteger();
        ExecutorService executorService = Executors.newFixedThreadPool(this.defaultParallelism(), new ThreadFactory(threadId){
            final /* synthetic */ AtomicInteger $threadId;

            @NotNull
            public final Thread newThread(Runnable it) {
                Thread thread;
                Thread $receiver = thread = new Thread(it, "CommonPool-worker-" + this.$threadId.incrementAndGet());
                $receiver.setDaemon(true);
                return thread;
            }
            {
                this.$threadId = atomicInteger;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newFixedThread\u2026Daemon = true }\n        }");
        return executorService;
    }

    private final int defaultParallelism() {
        return RangesKt.coerceAtLeast((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1);
    }

    private final synchronized Executor getOrCreatePoolSync() {
        Executor executor2 = _pool;
        if (executor2 == null) {
            ExecutorService executorService;
            ExecutorService it = executorService = this.createPool();
            _pool = it;
            executor2 = executorService;
        }
        return executor2;
    }

    @Override
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        try {
            Executor executor2 = _pool;
            if (executor2 == null) {
                executor2 = this.getOrCreatePoolSync();
            }
            executor2.execute(TimeSourceKt.getTimeSource().trackTask(block));
        }
        catch (RejectedExecutionException e) {
            TimeSourceKt.getTimeSource().unTrackTask();
            DefaultExecutor.INSTANCE.execute(block);
        }
    }

    public final synchronized void usePrivatePool$kotlinx_coroutines_core() {
        this.shutdown$kotlinx_coroutines_core(0L);
        usePrivatePool = true;
        _pool = null;
    }

    public final synchronized void shutdown$kotlinx_coroutines_core(long timeout) {
        Executor executor2 = _pool;
        if (!(executor2 instanceof ExecutorService)) {
            executor2 = null;
        }
        ExecutorService executorService = (ExecutorService)executor2;
        if (executorService != null) {
            ExecutorService executorService2;
            ExecutorService $receiver = executorService2 = executorService;
            $receiver.shutdown();
            if (timeout > 0L) {
                $receiver.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            }
            List<Runnable> list2 = $receiver.shutdownNow();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"shutdownNow()");
            Iterable $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                Runnable it;
                Runnable runnable = it = (Runnable)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"it");
                DefaultExecutor.INSTANCE.execute(runnable);
            }
        }
        _pool = shutdown.2.INSTANCE;
    }

    public final synchronized void restore$kotlinx_coroutines_core() {
        this.shutdown$kotlinx_coroutines_core(0L);
        usePrivatePool = false;
        _pool = null;
    }

    @Override
    @NotNull
    public String toString() {
        return "CommonPool";
    }

    private CommonPool() {
    }

    static {
        CommonPool commonPool;
        INSTANCE = commonPool = new CommonPool();
    }
}

