/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ConflictResolverDetails;

public class DefaultConflictResolverDetails<T extends ComponentResolutionState>
implements ConflictResolverDetails<T> {
    private final Collection<? extends T> participants;
    private T selected;
    private Throwable failure;
    private boolean restart;

    public DefaultConflictResolverDetails(Collection<? extends T> participants) {
        this.participants = participants;
    }

    @Override
    public Collection<? extends T> getCandidates() {
        return this.participants;
    }

    @Override
    public void select(T candidate) {
        if (this.restart) {
            throw new IllegalStateException("Cannot select a candidate if another candidate has been queued for restart");
        }
        this.selected = candidate;
    }

    @Override
    public void fail(Throwable error) {
        this.failure = error;
    }

    @Override
    public T getSelected() {
        return this.selected;
    }

    @Override
    public boolean isRestart() {
        return this.restart;
    }

    @Override
    @Nullable
    public Throwable getFailure() {
        return this.failure;
    }

    @Override
    public boolean hasFailure() {
        return this.failure != null;
    }

    @Override
    public boolean hasSelected() {
        return this.selected != null;
    }
}

