/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

public class DefaultBuildableComponentResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableComponentResolveResult {
    private final boolean retryMissing;
    private ComponentResolveMetadata metadata;
    private ModuleVersionResolveException failure;

    public DefaultBuildableComponentResolveResult() {
        this(true);
    }

    public DefaultBuildableComponentResolveResult(boolean retryMissing) {
        this.retryMissing = retryMissing;
    }

    @Override
    public DefaultBuildableComponentResolveResult failed(ModuleVersionResolveException failure) {
        this.metadata = null;
        this.failure = failure;
        return this;
    }

    @Override
    public void notFound(ModuleComponentIdentifier versionIdentifier) {
        this.failed(new ModuleVersionNotFoundException(DefaultModuleVersionIdentifier.newId(versionIdentifier), this.getAttempted()));
    }

    @Override
    public void resolved(ComponentResolveMetadata metaData) {
        this.metadata = metaData;
    }

    @Override
    public void setMetadata(ComponentResolveMetadata metadata) {
        this.assertResolved();
        this.metadata = metadata;
    }

    @Override
    public ComponentIdentifier getId() {
        this.assertResolved();
        return this.metadata.getId();
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.metadata.getModuleVersionId();
    }

    @Override
    public ComponentResolveMetadata getMetadata() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.metadata;
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    private void assertResolved() {
        this.assertHasResult();
        if (this.failure != null) {
            throw this.failure;
        }
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }

    @Override
    public boolean hasResult() {
        return this.failure != null || this.metadata != null;
    }

    public void applyTo(BuildableComponentIdResolveResult idResolve) {
        super.applyTo(idResolve);
        if (this.failure != null) {
            idResolve.failed(this.failure);
        }
        if (this.metadata != null) {
            idResolve.resolved(this.metadata);
        }
    }

    @Override
    public boolean isRetryMissing() {
        return this.retryMissing;
    }
}

