/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.hash.HashCode;

public abstract class AbstractNormalizedFileSnapshot
implements NormalizedFileSnapshot {
    private final FileType type;
    private final HashCode normalizedContentHash;

    public AbstractNormalizedFileSnapshot(FileType type, HashCode normalizedContentHash) {
        this.type = type;
        this.normalizedContentHash = normalizedContentHash;
    }

    @Override
    public final void appendToHasher(BuildCacheHasher hasher) {
        hasher.putString((CharSequence)this.getNormalizedPath());
        hasher.putHash(this.getNormalizedContentHash());
    }

    @Override
    public HashCode getNormalizedContentHash() {
        return this.normalizedContentHash;
    }

    @Override
    public FileType getType() {
        return this.type;
    }

    @Override
    public final int compareTo(NormalizedFileSnapshot o) {
        int result = this.getNormalizedPath().compareTo(o.getNormalizedPath());
        if (result == 0) {
            result = this.getNormalizedContentHash().compareTo(o.getNormalizedContentHash());
        }
        return result;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNormalizedFileSnapshot that = (AbstractNormalizedFileSnapshot)o;
        return this.normalizedContentHash.equals((Object)that.normalizedContentHash) && this.getNormalizedPath().equals(that.getNormalizedPath());
    }

    public final int hashCode() {
        int result = this.normalizedContentHash.hashCode();
        result = 31 * result + this.getNormalizedPath().hashCode();
        return result;
    }

    public final String toString() {
        return String.format("'%s' / %s", this.getNormalizedPath(), this.type == FileType.Directory ? "DIR" : (this.type == FileType.Missing ? "MISSING" : this.normalizedContentHash));
    }
}

