/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.util.Map;
import org.gradle.api.internal.changedetection.state.HistoricalTaskExecution;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.InputPropertiesSerializer;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.tasks.OriginTaskExecutionMetadata;
import org.gradle.internal.fingerprint.HistoricalFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class TaskExecutionFingerprintSerializer
extends AbstractSerializer<HistoricalTaskExecution> {
    private final InputPropertiesSerializer inputPropertiesSerializer;
    private final Serializer<HistoricalFileCollectionFingerprint> fileCollectionFingerprintSerializer;

    TaskExecutionFingerprintSerializer(Serializer<HistoricalFileCollectionFingerprint> fileCollectionFingerprintSerializer) {
        this.fileCollectionFingerprintSerializer = fileCollectionFingerprintSerializer;
        this.inputPropertiesSerializer = new InputPropertiesSerializer();
    }

    public HistoricalTaskExecution read(Decoder decoder) throws Exception {
        boolean successful = decoder.readBoolean();
        OriginTaskExecutionMetadata originExecutionMetadata = new OriginTaskExecutionMetadata(UniqueId.from((String)decoder.readString()), decoder.readLong());
        ImmutableSortedMap<String, HistoricalFileCollectionFingerprint> inputFilesFingerprints = this.readFingerprints(decoder);
        ImmutableSortedMap<String, HistoricalFileCollectionFingerprint> outputFilesFingerprints = this.readFingerprints(decoder);
        ImplementationSnapshot taskImplementation = TaskExecutionFingerprintSerializer.readImplementation(decoder);
        int taskActionsCount = decoder.readSmallInt();
        ImmutableList.Builder taskActionImplementationsBuilder = ImmutableList.builder();
        for (int j = 0; j < taskActionsCount; ++j) {
            ImplementationSnapshot actionImpl = TaskExecutionFingerprintSerializer.readImplementation(decoder);
            taskActionImplementationsBuilder.add((Object)actionImpl);
        }
        ImmutableList taskActionImplementations = taskActionImplementationsBuilder.build();
        int cacheableOutputPropertiesCount = decoder.readSmallInt();
        ImmutableSortedSet.Builder cacheableOutputPropertiesBuilder = ImmutableSortedSet.naturalOrder();
        for (int j = 0; j < cacheableOutputPropertiesCount; ++j) {
            cacheableOutputPropertiesBuilder.add((Object)decoder.readString());
        }
        ImmutableSortedSet cacheableOutputProperties = cacheableOutputPropertiesBuilder.build();
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = this.inputPropertiesSerializer.read(decoder);
        return new HistoricalTaskExecution(taskImplementation, (ImmutableList<ImplementationSnapshot>)taskActionImplementations, inputProperties, (ImmutableSortedSet<String>)cacheableOutputProperties, inputFilesFingerprints, outputFilesFingerprints, successful, originExecutionMetadata);
    }

    public void write(Encoder encoder, HistoricalTaskExecution execution) throws Exception {
        encoder.writeBoolean(execution.isSuccessful());
        encoder.writeString((CharSequence)execution.getOriginExecutionMetadata().getBuildInvocationId().asString());
        encoder.writeLong(execution.getOriginExecutionMetadata().getExecutionTime());
        this.writeFingerprints(encoder, (Map<String, HistoricalFileCollectionFingerprint>)execution.getInputFingerprints());
        this.writeFingerprints(encoder, (Map<String, HistoricalFileCollectionFingerprint>)execution.getOutputFingerprints());
        TaskExecutionFingerprintSerializer.writeImplementation(encoder, execution.getTaskImplementation());
        encoder.writeSmallInt(execution.getTaskActionImplementations().size());
        for (ImplementationSnapshot actionImpl : execution.getTaskActionImplementations()) {
            TaskExecutionFingerprintSerializer.writeImplementation(encoder, actionImpl);
        }
        encoder.writeSmallInt(execution.getOutputPropertyNamesForCacheKey().size());
        for (String outputFile : execution.getOutputPropertyNamesForCacheKey()) {
            encoder.writeString((CharSequence)outputFile);
        }
        this.inputPropertiesSerializer.write(encoder, (ImmutableMap<String, ValueSnapshot>)execution.getInputProperties());
    }

    private static ImplementationSnapshot readImplementation(Decoder decoder) throws IOException {
        String typeName = decoder.readString();
        HashCode classLoaderHash = decoder.readBoolean() ? HashCode.fromBytes((byte[])decoder.readBinary()) : null;
        return new ImplementationSnapshot(typeName, classLoaderHash);
    }

    private static void writeImplementation(Encoder encoder, ImplementationSnapshot implementation) throws IOException {
        encoder.writeString((CharSequence)implementation.getTypeName());
        if (implementation.hasUnknownClassLoader()) {
            encoder.writeBoolean(false);
        } else {
            encoder.writeBoolean(true);
            encoder.writeBinary(implementation.getClassLoaderHash().toByteArray());
        }
    }

    private ImmutableSortedMap<String, HistoricalFileCollectionFingerprint> readFingerprints(Decoder decoder) throws Exception {
        int count = decoder.readSmallInt();
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (int fingerprintIdx = 0; fingerprintIdx < count; ++fingerprintIdx) {
            String property = decoder.readString();
            HistoricalFileCollectionFingerprint fingerprint = (HistoricalFileCollectionFingerprint)this.fileCollectionFingerprintSerializer.read(decoder);
            builder.put((Object)property, (Object)fingerprint);
        }
        return builder.build();
    }

    private void writeFingerprints(Encoder encoder, Map<String, HistoricalFileCollectionFingerprint> fingerprints) throws Exception {
        encoder.writeSmallInt(fingerprints.size());
        for (Map.Entry<String, HistoricalFileCollectionFingerprint> entry : fingerprints.entrySet()) {
            encoder.writeString((CharSequence)entry.getKey());
            this.fileCollectionFingerprintSerializer.write(encoder, (Object)entry.getValue());
        }
    }
}

