/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GradleVersion;

public class UnsupportedJavaRuntimeException
extends GradleException {
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();
    public static final String JAVA7_DEPRECATION_WARNING = "Support for running Gradle using Java 7";
    private static final String JAVA7_DEPRECATION_WARNING_DOC = "Please see " + DOCUMENTATION_REGISTRY.getDocumentationFor("java_plugin", "sec:java_cross_compilation") + " for more details.";

    public UnsupportedJavaRuntimeException(String message) {
        super(message);
    }

    public static void javaDeprecationWarning() {
        if (!JavaVersion.current().isJava8Compatible()) {
            DeprecationLogger.nagUserWithDeprecatedBuildInvocationFeature((String)JAVA7_DEPRECATION_WARNING, (String)JAVA7_DEPRECATION_WARNING_DOC);
        }
    }

    public static void assertUsingVersion(String component, JavaVersion minVersion) throws UnsupportedJavaRuntimeException {
        JavaVersion current = JavaVersion.current();
        if (current.compareTo((Enum)minVersion) >= 0) {
            return;
        }
        throw new UnsupportedJavaRuntimeException(String.format("%s %s requires Java %s or later to run. You are currently using Java %s.", component, GradleVersion.current().getVersion(), minVersion.getMajorVersion(), current.getMajorVersion()));
    }

    public static void assertUsingVersion(String component, JavaVersion minVersion, JavaVersion configuredVersion) throws UnsupportedJavaRuntimeException {
        if (configuredVersion.compareTo((Enum)minVersion) >= 0) {
            return;
        }
        throw new UnsupportedJavaRuntimeException(String.format("%s %s requires Java %s or later to run. Your build is currently configured to use Java %s.", component, GradleVersion.current().getVersion(), minVersion.getMajorVersion(), configuredVersion.getMajorVersion()));
    }
}

