/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.gradle.internal.serialize.Encoder;

public abstract class AbstractEncoder
implements Encoder {
    private EncoderStream stream;

    public OutputStream getOutputStream() {
        if (this.stream == null) {
            this.stream = new EncoderStream();
        }
        return this.stream;
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.writeBytes(bytes, 0, bytes.length);
    }

    public void writeBinary(byte[] bytes) throws IOException {
        this.writeBinary(bytes, 0, bytes.length);
    }

    public void writeBinary(byte[] bytes, int offset, int count) throws IOException {
        this.writeSmallInt(count);
        this.writeBytes(bytes, offset, count);
    }

    public void writeSmallInt(int value) throws IOException {
        this.writeInt(value);
    }

    public void writeSmallLong(long value) throws IOException {
        this.writeLong(value);
    }

    public void writeNullableString(@Nullable CharSequence value) throws IOException {
        if (value == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeString(value.toString());
        }
    }

    private class EncoderStream
    extends OutputStream {
        private EncoderStream() {
        }

        public void write(byte[] buffer) throws IOException {
            AbstractEncoder.this.writeBytes(buffer);
        }

        public void write(byte[] buffer, int offset, int length) throws IOException {
            AbstractEncoder.this.writeBytes(buffer, offset, length);
        }

        public void write(int b) throws IOException {
            AbstractEncoder.this.writeByte((byte)b);
        }
    }
}

