/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.io.ClassLoaderObjectInputStream;
import org.gradle.workers.internal.ActionExecutionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializingActionExecutionSpec
implements ActionExecutionSpec {
    private final String displayName;
    private final Class<? extends Runnable> implementationClass;
    private final File executionWorkingDir;
    private final byte[] params;

    public SerializingActionExecutionSpec(Class<? extends Runnable> implementationClass, String displayName, File executionWorkingDir, Object[] params) {
        this.implementationClass = implementationClass;
        this.displayName = displayName;
        this.executionWorkingDir = executionWorkingDir;
        this.params = this.serialize(params);
    }

    @Override
    public Class<? extends Runnable> getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public File getExecutionWorkingDir() {
        return this.executionWorkingDir;
    }

    @Override
    public Object[] getParams(ClassLoader classLoader) {
        return this.deserialize(classLoader);
    }

    private byte[] serialize(Object[] params) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(params);
        }
        catch (IOException e) {
            throw new ParameterSerializationException("Could not serialize parameters", e);
        }
        return bos.toByteArray();
    }

    private Object[] deserialize(ClassLoader classLoader) {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.params);
        try {
            ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream((InputStream)bis, classLoader);
            return (Object[])ois.readObject();
        }
        catch (IOException e) {
            throw new ParameterSerializationException("Could not deserialize parameters", e);
        }
        catch (ClassNotFoundException e) {
            throw new ParameterSerializationException("Could not deserialize parameters", e);
        }
    }

    @Contextual
    static class ParameterSerializationException
    extends RuntimeException {
        ParameterSerializationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

