/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport;

import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resource.BuildOperationFiringExternalResourceDecorator;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.transfer.AccessorBackedExternalResource;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExternalResourceRepository
implements ExternalResourceRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExternalResourceRepository.class);
    private final String name;
    private final ExternalResourceAccessor accessor;
    private final ExternalResourceUploader uploader;
    private final ExternalResourceLister lister;
    private final ExternalResourceAccessor loggingAccessor;
    private final ExternalResourceUploader loggingUploader;
    private final BuildOperationExecutor buildOperationExecutor;

    public DefaultExternalResourceRepository(String name, ExternalResourceAccessor accessor, ExternalResourceUploader uploader, ExternalResourceLister lister, ExternalResourceAccessor loggingAccessor, ExternalResourceUploader loggingUploader, BuildOperationExecutor buildOperationExecutor) {
        this.name = name;
        this.accessor = accessor;
        this.uploader = uploader;
        this.lister = lister;
        this.loggingAccessor = loggingAccessor;
        this.loggingUploader = loggingUploader;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public ExternalResourceRepository withProgressLogging() {
        if (this.loggingAccessor == this.accessor && this.loggingUploader == this.uploader) {
            return this;
        }
        return new DefaultExternalResourceRepository(this.name, this.loggingAccessor, this.loggingUploader, this.lister, this.loggingAccessor, this.loggingUploader, this.buildOperationExecutor);
    }

    public ExternalResource resource(ExternalResourceName resource, boolean revalidate) {
        return new BuildOperationFiringExternalResourceDecorator(resource, this.buildOperationExecutor, (ExternalResource)new AccessorBackedExternalResource(resource, this.accessor, this.uploader, this.lister, revalidate));
    }

    public ExternalResource resource(ExternalResourceName resource) {
        return this.resource(resource, false);
    }

    public String toString() {
        return this.name;
    }
}

