/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveredInputsTaskStateChanges
implements TaskStateChanges {
    private final TaskExecution previous;
    private final TaskExecution current;

    public DiscoveredInputsTaskStateChanges(@Nullable TaskExecution previous, TaskExecution current) {
        this.previous = previous;
        this.current = current;
    }

    @Override
    public Iterator<TaskStateChange> iterator() {
        FileCollectionSnapshot previousDiscoveredInputs;
        FileCollectionSnapshot fileCollectionSnapshot = previousDiscoveredInputs = this.previous != null ? this.previous.getDiscoveredInputFilesSnapshot() : null;
        if (previousDiscoveredInputs == null) {
            return Iterators.singletonIterator((Object)new DescriptiveChange("Discovered input file history is not available.", new Object[0]));
        }
        return this.current.getDiscoveredInputFilesSnapshot().iterateContentChangesSince(previousDiscoveredInputs, "discovered input", true);
    }
}

