/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.AbstractPluginAware;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.caching.configuration.BuildCacheConfiguration;
import org.gradle.composite.internal.IncludedBuildFactory;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.ProjectDescriptorRegistry;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.resource.TextResourceLoader;
import org.gradle.internal.scripts.ScriptFileResolver;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.plugin.management.PluginManagementSpec;
import org.gradle.util.NameValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSettings
extends AbstractPluginAware
implements SettingsInternal {
    public static final String DEFAULT_BUILD_SRC_DIR = "buildSrc";
    private ScriptSource settingsScript;
    private StartParameter startParameter;
    private File settingsDir;
    private DefaultProjectDescriptor rootProjectDescriptor;
    private ProjectDescriptor defaultProjectDescriptor;
    private GradleInternal gradle;
    private final ClassLoaderScope settingsClassLoaderScope;
    private final ClassLoaderScope buildRootClassLoaderScope;
    private final ServiceRegistry services;
    private final Map<File, ConfigurableIncludedBuild> includedBuilds = Maps.newLinkedHashMap();

    public DefaultSettings(ServiceRegistryFactory serviceRegistryFactory, GradleInternal gradle, ClassLoaderScope settingsClassLoaderScope, ClassLoaderScope buildRootClassLoaderScope, File settingsDir, ScriptSource settingsScript, StartParameter startParameter) {
        this.gradle = gradle;
        this.buildRootClassLoaderScope = buildRootClassLoaderScope;
        this.settingsDir = settingsDir;
        this.settingsScript = settingsScript;
        this.startParameter = startParameter;
        this.settingsClassLoaderScope = settingsClassLoaderScope;
        this.services = serviceRegistryFactory.createFor(this);
        this.rootProjectDescriptor = this.createProjectDescriptor(null, NameValidator.asValidName(settingsDir.getName()), settingsDir);
    }

    public String toString() {
        return "settings '" + this.rootProjectDescriptor.getName() + "'";
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    public Settings getSettings() {
        return this;
    }

    public DefaultProjectDescriptor createProjectDescriptor(DefaultProjectDescriptor parent, String name, File dir) {
        return new DefaultProjectDescriptor(parent, name, dir, this.getProjectDescriptorRegistry(), this.getFileResolver(), this.getScriptFileResolver());
    }

    public DefaultProjectDescriptor findProject(String path) {
        return (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(path);
    }

    public DefaultProjectDescriptor findProject(File projectDir) {
        return (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(projectDir);
    }

    public DefaultProjectDescriptor project(String path) {
        DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(path);
        if (projectDescriptor == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found.", path));
        }
        return projectDescriptor;
    }

    public DefaultProjectDescriptor project(File projectDir) {
        DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(projectDir);
        if (projectDescriptor == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found.", projectDir));
        }
        return projectDescriptor;
    }

    public void include(String[] projectPaths) {
        for (String projectPath : projectPaths) {
            String subPath = "";
            String[] pathElements = this.removeTrailingColon(projectPath).split(":");
            DefaultProjectDescriptor parentProjectDescriptor = this.rootProjectDescriptor;
            for (String pathElement : pathElements) {
                subPath = subPath + ":" + pathElement;
                DefaultProjectDescriptor projectDescriptor = (DefaultProjectDescriptor)this.getProjectDescriptorRegistry().getProject(subPath);
                parentProjectDescriptor = projectDescriptor == null ? this.createProjectDescriptor(parentProjectDescriptor, pathElement, new File(parentProjectDescriptor.getProjectDir(), pathElement)) : projectDescriptor;
            }
        }
    }

    public void includeFlat(String[] projectNames) {
        for (String projectName : projectNames) {
            this.createProjectDescriptor(this.rootProjectDescriptor, projectName, new File(this.rootProjectDescriptor.getProjectDir().getParentFile(), projectName));
        }
    }

    private String removeTrailingColon(String projectPath) {
        if (projectPath.startsWith(":")) {
            return projectPath.substring(1);
        }
        return projectPath;
    }

    public ProjectDescriptor getRootProject() {
        return this.rootProjectDescriptor;
    }

    public void setRootProjectDescriptor(DefaultProjectDescriptor rootProjectDescriptor) {
        this.rootProjectDescriptor = rootProjectDescriptor;
    }

    @Override
    public ProjectDescriptor getDefaultProject() {
        return this.defaultProjectDescriptor;
    }

    @Override
    public void setDefaultProject(ProjectDescriptor defaultProjectDescriptor) {
        this.defaultProjectDescriptor = defaultProjectDescriptor;
    }

    public File getRootDir() {
        return this.rootProjectDescriptor.getProjectDir();
    }

    @Override
    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    public void setStartParameter(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    public File getSettingsDir() {
        return this.settingsDir;
    }

    public void setSettingsDir(File settingsDir) {
        this.settingsDir = settingsDir;
    }

    @Override
    public ScriptSource getSettingsScript() {
        return this.settingsScript;
    }

    public void setSettingsScript(ScriptSource settingsScript) {
        this.settingsScript = settingsScript;
    }

    @Inject
    public ProjectDescriptorRegistry getProjectDescriptorRegistry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectRegistry<DefaultProjectDescriptor> getProjectRegistry() {
        return this.getProjectDescriptorRegistry();
    }

    @Override
    protected DefaultObjectConfigurationAction createObjectConfigurationAction() {
        return new DefaultObjectConfigurationAction(this.getFileResolver(), this.getScriptPluginFactory(), this.getScriptHandlerFactory(), this.getRootClassLoaderScope(), this.getResourceLoader(), this);
    }

    @Override
    public ClassLoaderScope getRootClassLoaderScope() {
        return this.buildRootClassLoaderScope;
    }

    @Override
    public ClassLoaderScope getClassLoaderScope() {
        return this.settingsClassLoaderScope;
    }

    protected ServiceRegistry getServices() {
        return this.services;
    }

    @Inject
    protected ScriptFileResolver getScriptFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected TextResourceLoader getResourceLoader() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ScriptHandlerFactory getScriptHandlerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ScriptPluginFactory getScriptPluginFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected IncludedBuildFactory getIncludedBuildFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public PluginManagerInternal getPluginManager() {
        throw new UnsupportedOperationException();
    }

    public void includeBuild(Object rootProject) {
        this.includeBuild(rootProject, (Action<ConfigurableIncludedBuild>)Actions.doNothing());
    }

    public void includeBuild(Object rootProject, Action<ConfigurableIncludedBuild> configuration) {
        File projectDir = this.getFileResolver().resolve(rootProject);
        ConfigurableIncludedBuild build = this.includedBuilds.get(projectDir);
        if (build == null) {
            build = this.getIncludedBuildFactory().createBuild(projectDir);
            this.includedBuilds.put(projectDir, build);
        }
        configuration.execute((Object)build);
    }

    @Override
    public Map<File, IncludedBuild> getIncludedBuilds() {
        return (Map)Cast.uncheckedCast(this.includedBuilds);
    }

    public void buildCache(Action<? super BuildCacheConfiguration> action) {
        action.execute((Object)this.getBuildCache());
    }

    @Inject
    public BuildCacheConfiguration getBuildCache() {
        throw new UnsupportedOperationException();
    }

    public void pluginManagement(Action<? super PluginManagementSpec> rule) {
        rule.execute((Object)this.getPluginManagement());
    }

    @Inject
    public PluginManagementSpec getPluginManagement() {
        throw new UnsupportedOperationException();
    }
}

