/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.scripts;

import java.io.File;
import java.util.ArrayList;
import org.gradle.internal.scripts.ScriptFileResolver;
import org.gradle.scripts.ScriptingLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptFileResolver
implements ScriptFileResolver {
    private final Iterable<String> scriptingExtensions;

    public static ScriptFileResolver forScriptingLanguages(Iterable<ScriptingLanguage> scriptingLanguages) {
        ArrayList<String> extensions = new ArrayList<String>();
        for (ScriptingLanguage scriptingLanguage : scriptingLanguages) {
            extensions.add(scriptingLanguage.getExtension());
        }
        return new DefaultScriptFileResolver(extensions);
    }

    private DefaultScriptFileResolver(Iterable<String> scriptingExtensions) {
        this.scriptingExtensions = scriptingExtensions;
    }

    @Override
    public File resolveScriptFile(File dir, String basename) {
        for (String extension : this.scriptingExtensions) {
            File scriptFile = new File(dir, basename + extension);
            if (!scriptFile.isFile()) continue;
            return scriptFile;
        }
        return null;
    }
}

