/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.ProcessLauncher;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.jni.WindowsHandleFunctions;

public class WindowsProcessLauncher
implements ProcessLauncher {
    private final ProcessLauncher launcher;

    public WindowsProcessLauncher(ProcessLauncher launcher) {
        this.launcher = launcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Process start(ProcessBuilder processBuilder) throws NativeException {
        Process process2;
        FunctionResult result2 = new FunctionResult();
        WindowsHandleFunctions.markStandardHandlesUninheritable(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not start '%s': %s", processBuilder.command().get(0), result2.getMessage()));
        }
        try {
            process2 = this.launcher.start(processBuilder);
        }
        catch (Throwable throwable) {
            WindowsHandleFunctions.restoreStandardHandles(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not restore process handles: %s", result2.getMessage()));
            }
            throw throwable;
        }
        WindowsHandleFunctions.restoreStandardHandles(result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not restore process handles: %s", result2.getMessage()));
        }
        return process2;
    }
}

