/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

public class RangeCodegenUtil {
    private static final ImmutableMap<FqName, PrimitiveType> RANGE_TO_ELEMENT_TYPE;
    private static final ImmutableMap<FqName, PrimitiveType> PROGRESSION_TO_ELEMENT_TYPE;

    @NotNull
    public static List<PrimitiveType> supportedRangeTypes() {
        List<PrimitiveType> list2 = Arrays.asList(PrimitiveType.CHAR, PrimitiveType.INT, PrimitiveType.LONG);
        if (list2 == null) {
            RangeCodegenUtil.$$$reportNull$$$0(0);
        }
        return list2;
    }

    private RangeCodegenUtil() {
    }

    public static boolean isRange(KotlinType rangeType) {
        return !rangeType.isMarkedNullable() && RangeCodegenUtil.getPrimitiveRangeElementType(rangeType) != null;
    }

    public static boolean isProgression(KotlinType rangeType) {
        return !rangeType.isMarkedNullable() && RangeCodegenUtil.getPrimitiveProgressionElementType(rangeType) != null;
    }

    @Nullable
    private static PrimitiveType getPrimitiveRangeElementType(KotlinType rangeType) {
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(rangeType, RANGE_TO_ELEMENT_TYPE);
    }

    @Nullable
    private static PrimitiveType getPrimitiveProgressionElementType(KotlinType rangeType) {
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(rangeType, PROGRESSION_TO_ELEMENT_TYPE);
    }

    @Nullable
    private static PrimitiveType getPrimitiveRangeOrProgressionElementType(@NotNull KotlinType rangeOrProgression, @NotNull ImmutableMap<FqName, PrimitiveType> map2) {
        ClassifierDescriptor declarationDescriptor;
        if (rangeOrProgression == null) {
            RangeCodegenUtil.$$$reportNull$$$0(1);
        }
        if (map2 == null) {
            RangeCodegenUtil.$$$reportNull$$$0(2);
        }
        if ((declarationDescriptor = rangeOrProgression.getConstructor().getDeclarationDescriptor()) == null) {
            return null;
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(declarationDescriptor);
        if (!fqName2.isSafe()) {
            return null;
        }
        return map2.get(fqName2.toSafe());
    }

    @Nullable
    public static PrimitiveType getPrimitiveRangeOrProgressionElementType(@NotNull FqName rangeOrProgressionName) {
        PrimitiveType result2;
        if (rangeOrProgressionName == null) {
            RangeCodegenUtil.$$$reportNull$$$0(3);
        }
        return (result2 = RANGE_TO_ELEMENT_TYPE.get(rangeOrProgressionName)) != null ? result2 : PROGRESSION_TO_ELEMENT_TYPE.get(rangeOrProgressionName);
    }

    public static boolean isRangeOrProgression(@NotNull FqName className2) {
        if (className2 == null) {
            RangeCodegenUtil.$$$reportNull$$$0(4);
        }
        return RangeCodegenUtil.getPrimitiveRangeOrProgressionElementType(className2) != null;
    }

    public static boolean isPrimitiveNumberRangeTo(CallableDescriptor rangeTo) {
        if (!"rangeTo".equals(rangeTo.getName().asString())) {
            return false;
        }
        return AsmUtil.isPrimitiveNumberClassDescriptor(rangeTo.getContainingDeclaration());
    }

    private static boolean isPrimitiveRangeToExtension(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            RangeCodegenUtil.$$$reportNull$$$0(5);
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "rangeTo", "kotlin.ranges")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver == null) {
            return false;
        }
        return KotlinBuiltIns.isPrimitiveType(extensionReceiver.getType());
    }

    public static boolean isPrimitiveNumberDownTo(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            RangeCodegenUtil.$$$reportNull$$$0(6);
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "downTo", "kotlin.ranges")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver == null) {
            return false;
        }
        ClassifierDescriptor extensionReceiverClassifier = extensionReceiver.getType().getConstructor().getDeclarationDescriptor();
        return AsmUtil.isPrimitiveNumberClassDescriptor(extensionReceiverClassifier);
    }

    public static boolean isPrimitiveNumberUntil(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            RangeCodegenUtil.$$$reportNull$$$0(7);
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "until", "kotlin.ranges")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver == null) {
            return false;
        }
        ClassifierDescriptor extensionReceiverClassifier = extensionReceiver.getType().getConstructor().getDeclarationDescriptor();
        return AsmUtil.isPrimitiveNumberClassDescriptor(extensionReceiverClassifier);
    }

    public static boolean isArrayOrPrimitiveArrayIndices(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            RangeCodegenUtil.$$$reportNull$$$0(8);
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "indices", "kotlin.collections")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver == null) {
            return false;
        }
        KotlinType extensionReceiverType = extensionReceiver.getType();
        return KotlinBuiltIns.isArray(extensionReceiverType) || KotlinBuiltIns.isPrimitiveArray(extensionReceiverType);
    }

    public static boolean isCollectionIndices(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            RangeCodegenUtil.$$$reportNull$$$0(9);
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "indices", "kotlin.collections")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver == null) {
            return false;
        }
        KotlinType extensionReceiverType = extensionReceiver.getType();
        return KotlinBuiltIns.isCollectionOrNullableCollection(extensionReceiverType);
    }

    public static boolean isCharSequenceIndices(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            RangeCodegenUtil.$$$reportNull$$$0(10);
        }
        if (!RangeCodegenUtil.isTopLevelInPackage(descriptor2, "indices", "kotlin.text")) {
            return false;
        }
        ReceiverParameterDescriptor extensionReceiver = descriptor2.getExtensionReceiverParameter();
        if (extensionReceiver == null) {
            return false;
        }
        KotlinType extensionReceiverType = extensionReceiver.getType();
        return KotlinBuiltIns.isCharSequenceOrNullableCharSequence(extensionReceiverType);
    }

    public static boolean isPrimitiveRangeToExtension(@NotNull KtSimpleNameExpression operationReference, @NotNull BindingContext bindingContext) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        ReceiverValue receiver;
        if (operationReference == null) {
            RangeCodegenUtil.$$$reportNull$$$0(11);
        }
        if (bindingContext == null) {
            RangeCodegenUtil.$$$reportNull$$$0(12);
        }
        if (!((receiver = (resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(operationReference, bindingContext)).getDispatchReceiver()) instanceof ExpressionReceiver)) {
            return false;
        }
        ExpressionReceiver e = (ExpressionReceiver)receiver;
        ResolvedCall<? extends CallableDescriptor> resolvedReceiver = CallUtilKt.getResolvedCall(e.getExpression(), bindingContext);
        if (resolvedReceiver == null) {
            return false;
        }
        return RangeCodegenUtil.isPrimitiveRangeToExtension(resolvedReceiver.getResultingDescriptor());
    }

    public static boolean isPrimitiveRangeSpecializationOfType(@NotNull Type argumentType, @NotNull KtExpression rangeExpression, @NotNull BindingContext bindingContext) {
        if (argumentType == null) {
            RangeCodegenUtil.$$$reportNull$$$0(13);
        }
        if (rangeExpression == null) {
            RangeCodegenUtil.$$$reportNull$$$0(14);
        }
        if (bindingContext == null) {
            RangeCodegenUtil.$$$reportNull$$$0(15);
        }
        if (rangeExpression instanceof KtBinaryExpression && ((KtBinaryExpression)rangeExpression).getOperationReference().getReferencedNameElementType() == KtTokens.RANGE) {
            KotlinType kotlinType = bindingContext.getType(rangeExpression);
            assert (kotlinType != null);
            ClassifierDescriptor descriptor2 = kotlinType.getConstructor().getDeclarationDescriptor();
            if (descriptor2 != null) {
                FqNameUnsafe fqName2 = DescriptorUtils.getFqName(descriptor2);
                if (fqName2.equals(KotlinBuiltIns.FQ_NAMES.longRange)) {
                    return argumentType == Type.LONG_TYPE;
                }
                if (fqName2.equals(KotlinBuiltIns.FQ_NAMES.charRange) || fqName2.equals(KotlinBuiltIns.FQ_NAMES.intRange)) {
                    return AsmUtil.isIntPrimitive(argumentType);
                }
            }
        }
        return false;
    }

    private static boolean isTopLevelInPackage(@NotNull CallableDescriptor descriptor2, @NotNull String name, @NotNull String packageName) {
        if (descriptor2 == null) {
            RangeCodegenUtil.$$$reportNull$$$0(16);
        }
        if (name == null) {
            RangeCodegenUtil.$$$reportNull$$$0(17);
        }
        if (packageName == null) {
            RangeCodegenUtil.$$$reportNull$$$0(18);
        }
        if (!name.equals(descriptor2.getName().asString())) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (!(containingDeclaration instanceof PackageFragmentDescriptor)) {
            return false;
        }
        String packageFqName = ((PackageFragmentDescriptor)containingDeclaration).getFqName().asString();
        return packageName.equals(packageFqName);
    }

    static {
        ImmutableMap.Builder<FqName, PrimitiveType> rangeBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<FqName, PrimitiveType> progressionBuilder = ImmutableMap.builder();
        for (PrimitiveType primitiveType : RangeCodegenUtil.supportedRangeTypes()) {
            FqName rangeClassFqName = KotlinBuiltIns.RANGES_PACKAGE_FQ_NAME.child(Name.identifier(primitiveType.getTypeName() + "Range"));
            FqName progressionClassFqName = KotlinBuiltIns.RANGES_PACKAGE_FQ_NAME.child(Name.identifier(primitiveType.getTypeName() + "Progression"));
            rangeBuilder.put(rangeClassFqName, primitiveType);
            progressionBuilder.put(progressionClassFqName, primitiveType);
        }
        RANGE_TO_ELEMENT_TYPE = rangeBuilder.build();
        PROGRESSION_TO_ELEMENT_TYPE = progressionBuilder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/RangeCodegenUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeOrProgression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeOrProgressionName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationReference";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeExpression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "supportedRangeTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/RangeCodegenUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveRangeOrProgressionElementType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRangeOrProgression";
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveRangeToExtension";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveNumberDownTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveNumberUntil";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isArrayOrPrimitiveArrayIndices";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCollectionIndices";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCharSequenceIndices";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveRangeSpecializationOfType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelInPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

