/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClassUtilKt;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.serialization.deserialization.BinaryVersion;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"findLastReturn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "node", "insertLegacySuspendInlineMarks", "", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "isLegacySuspendInlineFunction", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "produceSuspendMarker", "isStartNotEnd", "kotlin-compiler"})
public final class LegacyInlineSuspendUtilKt {
    public static final void insertLegacySuspendInlineMarks(@NotNull MethodNode node) {
        InsnList insnList;
        Intrinsics.checkParameterIsNotNull(node, "node");
        InsnList $receiver = insnList = node.instructions;
        AbstractInsnNode abstractInsnNode = LegacyInlineSuspendUtilKt.findLastReturn($receiver.getLast());
        if (abstractInsnNode == null) {
            return;
        }
        $receiver.insertBefore(abstractInsnNode, LegacyInlineSuspendUtilKt.produceSuspendMarker((boolean)false).instructions);
        $receiver.insertBefore($receiver.getFirst(), LegacyInlineSuspendUtilKt.produceSuspendMarker((boolean)true).instructions);
        node.maxStack = RangesKt.coerceAtLeast(node.maxStack, 2);
    }

    @Nullable
    public static final AbstractInsnNode findLastReturn(@Nullable AbstractInsnNode node) {
        AbstractInsnNode cur;
        for (cur = node; cur != null && cur.getOpcode() != 176; cur = cur.getPrevious()) {
        }
        return cur;
    }

    private static final MethodNode produceSuspendMarker(boolean isStartNotEnd) {
        MethodNode methodNode;
        MethodNode it = methodNode = new MethodNode();
        InlineCodegenUtilsKt.addSuspendMarker(new InstructionAdapter(it), isStartNotEnd);
        return methodNode;
    }

    public static final boolean isLegacySuspendInlineFunction(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return false;
        }
        if (!((FunctionDescriptor)descriptor2).isSuspend() || !((FunctionDescriptor)descriptor2).isInline()) {
            return false;
        }
        Object object = KotlinJvmBinaryClassUtilKt.getContainingKotlinJvmBinaryClass(descriptor2);
        if (object == null || (object = object.getClassHeader()) == null || (object = ((KotlinClassHeader)object).getBytecodeVersion()) == null) {
            return false;
        }
        Object jvmBytecodeVersion = object;
        return !((BinaryVersion)jvmBytecodeVersion).isAtLeast(1, 0, 2);
    }
}

