/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.ExternalAnnotationsListener;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;

public abstract class ExternalAnnotationsManager {
    public static final String ANNOTATIONS_XML = "annotations.xml";
    public static final Topic<ExternalAnnotationsListener> TOPIC = Topic.create("external annotations", ExternalAnnotationsListener.class);
    private static final NotNullLazyKey<ExternalAnnotationsManager, Project> INSTANCE_KEY = ServiceManager.createLazyKey(ExternalAnnotationsManager.class);

    public static ExternalAnnotationsManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/codeInsight/ExternalAnnotationsManager", "getInstance"));
        }
        return INSTANCE_KEY.getValue(project);
    }

    public abstract boolean isExternalAnnotation(@NotNull PsiAnnotation var1);

    @Nullable
    public abstract PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner var1, @NotNull String var2);

    public abstract boolean isExternalAnnotationWritable(@NotNull PsiModifierListOwner var1, @NotNull String var2);

    @Nullable
    public abstract PsiAnnotation[] findExternalAnnotations(@NotNull PsiModifierListOwner var1);

    public abstract void annotateExternally(@NotNull PsiModifierListOwner var1, @NotNull String var2, @NotNull PsiFile var3, @Nullable PsiNameValuePair[] var4) throws CanceledConfigurationException;

    public abstract boolean deannotate(@NotNull PsiModifierListOwner var1, @NotNull String var2);

    public abstract boolean editExternalAnnotation(@NotNull PsiModifierListOwner var1, @NotNull String var2, @Nullable PsiNameValuePair[] var3);

    public abstract AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement var1);

    @Nullable
    public abstract List<PsiFile> findExternalAnnotationsFiles(@NotNull PsiModifierListOwner var1);

    public static class CanceledConfigurationException
    extends RuntimeException {
        public static final CanceledConfigurationException INSTANCE = new CanceledConfigurationException();

        private CanceledConfigurationException() {
        }
    }

    public static enum AnnotationPlace {
        IN_CODE,
        EXTERNAL,
        NOWHERE;

    }
}

